/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.logging.Level;

import com.sun.enterprise.tools.verifier.Result;

/** 
 * Listener class must implement a no arg constructor.
 * Verify that the Listener class implements a no arg constructor.
 *
 * @author Jerome Dochez
 * @version 1.0
 */
public class ListenerClassHasValidConstructor extends ListenerClass implements WebCheck {
    /**
     * <p>
     * Run the verifier test against a declared individual listener class
     * </p>
     *
     * @param result is used to put the test results in
     * @param listenerClass is the individual listener class object to test
     * @return true if the test pass
     */                
    protected boolean runIndividualListenerTest(Result result, Class listenerClass) {
        
        boolean validConstructor = false;
        boolean foundIt = false;
        
        if (listenerClass == null) 
            return false;
        
        // walk up the class tree 
        do {
            Constructor[] constructors = listenerClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; i++) {
                logger.log(Level.FINE, getClass().getName() + ".debug",
                        new Object[] {constructors[i].toString()});
                Class[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == 0) {
                    if (Modifier.isPublic(constructors[i].getModifiers())) {
                        validConstructor=true;
                    } else {
                        validConstructor=false;
                    }
                    foundIt = true;
                    break;
                }
            }
        } while ((!foundIt) && ((listenerClass=listenerClass.getSuperclass()) != null));
        
        if (validConstructor) {
	   
            result.addGoodDetails(smh.getLocalString
                (getClass().getName() + ".passed",
                    "Listener class [ {0} ] implements a valid constructor.",
                    new Object[] {listenerClass.getName()}));
        } else {
	 
            result.addErrorDetails(smh.getLocalString
                (getClass().getName() + ".failed",
                 "Error: Listener class [ {0} ] does not implement a valid constructor.",
                 new Object[] {listenerClass.getName()}));
        }   
        return validConstructor;
    }
}
