/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

public abstract class URLPatternUnique extends WebTest implements WebCheck { 
    /** 
     * the url-pattern should be unique. Refer to bug#4903615 
	 * This test serves as a base class for three classes.
	 * It has a pure virtual function which has to be implemented in concrete subclasses.
     * Note: This right now reports WARNING, as it is not clear from spec
	 * if it should report a failure.
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {
        boolean na=true, warning=false;
        Result result = getInitializedResult();
        ComponentNameConstructor compName =
                getVerifierContext().getComponentNameConstructor();
        //this warning will be displayed depending on the final status.
        result.addWarningDetails(smh.getLocalString
                                                   ("tests.componentNameConstructor",
                                                        "For [ {0} ]",
                                                        new Object[] {compName.toString()}));

        //Assumes that DOL gives us the list of url-patterns including duplicates
        Set<String> urlPatterns=new HashSet<String>();
        for(Iterator iter=getUrlPatterns(descriptor).iterator();iter.hasNext();){
            na=false;
            String urlPattern=(String)iter.next();
            if(!urlPatterns.add(urlPattern)){
                    warning=true;
                    result.setStatus(Result.WARNING);
                    result.addWarningDetails(smh.getLocalString
                                                     (getClass().getName() + ".warning",
                                                      "url-pattern [ {0} ] already exists in web archive [ {1} ]",
                                                      new Object[] {urlPattern, descriptor.getName()}));
            }
        }

        if(na){
            result.setStatus(Result.NOT_APPLICABLE);
            result.addNaDetails(smh.getLocalString
                                               ("tests.componentNameConstructor",
                                                    "For [ {0} ]",
                                                    new Object[] {compName.toString()}));	    
            result.addNaDetails(smh.getLocalString
                                                     (getClass().getName() + ".notApplicable",
                                                    "There is no url-pattern element within the web archive [ {0} ]",
                                                    new Object[] {descriptor.getName()}));
        }else if(!warning) {
            result.passed(smh.getLocalString
                                               ("tests.componentNameConstructor",
                                                    "For [ {0} ]",
                                                    new Object[] {compName.toString()}));	    
            result.addGoodDetails(smh.getLocalString
                                                     (getClass().getName() + ".passed",
                                                    "All the url-patterns are unique within the web archive [ {0} ]",
                                                    new Object[] {descriptor.getName()}));
        }
        return result;
    }
    protected abstract Collection getUrlPatterns(WebBundleDescriptor descriptor);
}
