/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;

public class URLPatternUniqueInSecurityConstraints extends URLPatternUnique{ 
    protected Collection getUrlPatterns(WebBundleDescriptor descriptor) {
        ArrayList<Object>patterns=new ArrayList<Object>();
        for (Enumeration e=descriptor.getSecurityConstraints(); e.hasMoreElements();){
            for (Enumeration ee = ((SecurityConstraint) e.nextElement()).getWebResourceCollections(); ee.hasMoreElements();) {
                for (Enumeration eee=((WebResourceCollection) ee.nextElement()).getUrlPatterns(); eee.hasMoreElements();) {
                    patterns.add(eee.nextElement());
                }
            }
        }
	return patterns;
    }
}
