/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.util.*;

/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids: JSR109_WS_57; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: The service-endpoint-interface element defines a fully qualified Java class 
 *   that represents the Service Endpoint Interface of a WSDL port.
 */

public class PortCompRefSEIClassCheck  extends WSClientTest implements WSClientCheck {
    ComponentNameConstructor compName;

    /**
     * @param descriptor the WebServices  descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (ServiceReferenceDescriptor descriptor) {

	Result result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();

        boolean pass = true;

        Collection ports = descriptor.getPortsInfo();

        for (Iterator it=ports.iterator(); it.hasNext();) {
            ServiceRefPortInfo ref = (ServiceRefPortInfo)it.next();
            if (!loadSEIClass(ref,result)) {
               //result.fail ref.getName(), ref.getServiceEndpointInterface
               result.addErrorDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]", new Object[] {compName.toString()}));
               result.failed(smh.getLocalString
                   (getClass().getName() + ".failed",
                    "Error: Service Endpoint Interface class [ {0} ]  not found.",
                    new Object[] {ref.getServiceEndpointInterface()}));
               
               pass = false;
            }
            else {
              //result.pass
              result.addGoodDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]", new Object[] {compName.toString()}));
              result.passed(smh.getLocalString (getClass().getName() + ".passed",
              "Service Endpoint Interface class [ {0} ]  found.", 
              new Object[] {ref.getServiceEndpointInterface()}));

            }
        }

        return result;
    }

   private boolean loadSEIClass(ServiceRefPortInfo ref, Result result) {

     boolean pass = true;

     if (ref.hasServiceEndpointInterface()) {
        try {
              Class.forName(ref.getServiceEndpointInterface(), false, getVerifierContext().getClassLoader());
           } catch (ClassNotFoundException e) {
               Verifier.debug(e);
               pass = false;
           }
     }
     else {
       //result.not applicable (SEI not specified)
       result.addNaDetails(smh.getLocalString
                     ("tests.componentNameConstructor", "For [ {0} ]",
                      new Object[] {compName.toString()}));
       result.notApplicable(smh.getLocalString
                 ( getClass().getName() + ".notapp",
                 "Not applicable since Service reference does not specify an SEI."));

     }
    return pass;
   }
 }

