/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

//OutputStreamWrapper - Java Source


//***************** package ***********************************************

package com.sun.jdo.api.persistence.enhancer;


//***************** import ************************************************

import java.io.OutputStream;


//#########################################################################
/**
 *  This class serves as a wrapper for an output stream of a class file. The
 *  stream is passed as a parameter to the byte code enhancer, that can
 *  sets the classname of the written Java class to the wrapper.
 *  <br>
 *  This wrapper is necessary to determine the classname outside the enhancer,
 *  after the class has been enhanced, since do do not always know the
 *  classname of an opened input stream.
 *  </p>
 */
//#########################################################################

public class OutputStreamWrapper
{


    /**
     *  The wrapped output stream.
     */
    private OutputStream out;


    /**
     *  The classname of the written Java class. This parameter
     *  is set by the enhancer.
     */
    private String className = null;


    /**********************************************************************
     *  Constructs a new object.
     *
     *  @param  out  The output stream to wrap.
     *********************************************************************/

    public OutputStreamWrapper (OutputStream out)
    {

        this.out = out;

    }  //OutputStreamWrapper.<init>


    /**********************************************************************
     *  Gets the wrapped output stream.
     *
     *  @return  The wrapped output stream.
     *
     *  @see #out
     *********************************************************************/

    public final OutputStream getStream ()
    {

        return this.out;

    }  //NamedOuptutStream.getStream()


    /**********************************************************************
     *  Gets the classname of the written Java class. This method should be
     *  called after the class has been enhanced.
     *
     *  @return  The name of the written Java class.
     *
     *  @see  #className
     *********************************************************************/

    public final String getClassName ()
    {

        return this.className;

    }  //OutputStreamWrapper.getClassName()


    /**********************************************************************
     *  Sets the name of the written Java class. This method should be called
     *  by the enhancer.
     *
     *  @param  classname  The name of the Java class.
     *
     *  @see  #className
     *********************************************************************/

    public final void setClassName (String classname)
    {

        this.className = classname;

    }  //OutputStreamWrapper.setClassName()


}  //OutputStreamWrapper


//OutputStreamWrapper - Java Source End
