/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

/**
 * ClassMember is a common base class for ClassMethod and ClassField
 */

abstract public class ClassMember implements VMConstants {

  /* public accessors */

  /**
   * Is the member static?
   */
  final public boolean isStatic() {
    return (access() & ACCStatic) != 0;
  }

  /**
   * Is the member final?
   */
  final public boolean isFinal() {
    return (access() & ACCFinal) != 0;
  }

  /**
   * Turn on or off the final qualifier for the member.
   */
  public void setIsFinal(boolean newFinal) {
    if (newFinal)
      setAccess(access() | ACCFinal);
    else
      setAccess(access() & ~ACCFinal);
  }

  /**
   * Is the member private?
   */
  final public boolean isPrivate() {
    return (access() & ACCPrivate) != 0;
  }

  /**
   * Is the member protected?
   */
  final public boolean isProtected() {
    return (access() & ACCProtected) != 0;
  }

  /**
   * Is the member public?
   */
  final public boolean isPublic() {
    return (access() & ACCPublic) != 0;
  }

  /* These are expected to be implemented by subtypes */

  /**
   * Return the access flags for the method - see VMConstants
   */
  abstract public int access();

  /**
   * Set the access flags for the method - see VMConstants
   */
  abstract public void setAccess(int newAccess);

  /**
   * Return the name of the member
   */
  abstract public ConstUtf8 name();

  /**
   * Return the type signature of the method
   */
  abstract public ConstUtf8 signature();

  /**
   * Return the attributes associated with the member
   */
  abstract public AttributeVector attributes();

}


