/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * ConstFieldRef represents a reference to a field of some class
 * in the constant pool of a class file.
 */

public class ConstFieldRef extends ConstBasicMemberRef {
  /* The tag associated with ConstFieldRef */
  public static final int MyTag = CONSTANTFieldRef;

  /* public accessors */
  public int tag () { return MyTag; }

  public String toString () {
      return "CONSTANTFieldRef(" + indexAsString() + "): " + //NOI18N
           super.toString();
  }

  /* package local methods */

  ConstFieldRef (ConstClass cname, ConstNameAndType NT) {
    super(cname, NT);
  }

  ConstFieldRef (int cnameIndex, int NT_index) {
    super(cnameIndex, NT_index);
  }

  static ConstFieldRef read (DataInputStream input) throws IOException {
    int cname = input.readUnsignedShort();
    int NT = input.readUnsignedShort();
    return new ConstFieldRef (cname, NT);
  }

}

