/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a class specification in the constant pool
 */

/*
   ConstString strictly speaking is not a ConstantValue in the
   Java VM sense.  However, the compiler generates ConstantValue attributes
   which refer to ConstString entries.  This occurs for initialized static
   final String fields.  I've changed ConstString to be a ConstValue for 
   now as a simplification.
*/

public class ConstString extends ConstValue {
  /* The tag associated with ConstClass entries */
  public static final int MyTag = CONSTANTString;

  /* The name of the class being referred to */
  private ConstUtf8 stringValue;

  /* The index of name of the class being referred to
   *  - used while reading from a class file */
  private int stringValueIndex;

  /* public accessors */

  /**
   * Return the tag for this constant
   */
  public int tag () { return MyTag; }

  /**
   * Return the utf8 string calue
   */
  public ConstUtf8 value() {
    return stringValue;
  }

  /**
   * Return the descriptor string for the constant type.
   */
  public String descriptor() {
      return "Ljava/lang/String;";//NOI18N
  }

  /**
   * A printable representation 
   */
  public String toString () {
      return "CONSTANTString(" + indexAsString() + "): " + //NOI18N
          "string(" + stringValue.asString() + ")";//NOI18N
  }

  /* package local methods */

  ConstString (ConstUtf8 s) {
    stringValue = s;
  }

  ConstString (int sIndex) {
    stringValueIndex = sIndex;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeShort (stringValue.getIndex());
  }
  static ConstString read (DataInputStream input) throws IOException {
    return new ConstString (input.readUnsignedShort());
  }
  void resolve (ConstantPool p) {
    stringValue = (ConstUtf8) p.constantAt(stringValueIndex);
  }
}


