/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ClassLoaderStrategy.java
 *
 * Created on August 29, 2003, 3:19 PM
 */

package com.sun.jdo.api.persistence.model;

/**
 *
 * @author mvatkina
 * @version %I%
 */
public class ClassLoaderStrategy
{
	/** System property key used to define the model behavior concerning
	 * multiple class loaders. 
	 * Value should be one of 
	 * {@link #MULTIPLE_CLASS_LOADERS_IGNORE},
	 * {@link #MULTIPLE_CLASS_LOADERS_RELOAD}, or 
	 * {@link #MULTIPLE_CLASS_LOADERS_ERROR}
	 */
	public static final String PROPERTY_MULTIPLE_CLASS_LOADERS =
		"com.sun.jdo.api.persistence.model.multipleClassLoaders"; //NOI18N
	
	/** Constant representing the value "ignore" of the System property
	 * com.sun.jdo.api.persistence.model.multipleClassLoaders
	 * Setting the system property to "ignore" causes the model to ignore
	 * any new class loader for the same fully qualified class name.
	 * @see RuntimeModel#findClassLoader
	 */
	public static final String MULTIPLE_CLASS_LOADERS_IGNORE = "ignore"; //NOI18N

	/** Constant representing the value "reload" of the System property
	 * com.sun.jdo.api.persistence.model.multipleClassLoaders 
	 * Setting the system property to "reload" causes the model to reload 
	 * the class mapping if it is specified with a new class loader.
	 * @see RuntimeModel#findClassLoader
	 */
	public static final String MULTIPLE_CLASS_LOADERS_RELOAD = "reload"; //NOI18N

	/** Constant representing the value "error" of the System property
	 * com.sun.jdo.api.persistence.model.multipleClassLoaders
	 * Setting the system property to "reload" causes the model to throw an
	 * exception if the same class is used with a diferent class loader.
	 * @see RuntimeModel#findClassLoader
	 */
	public static final String MULTIPLE_CLASS_LOADERS_ERROR = "error"; //NOI18N

	/** Value of the property used to define the model behavior concerning
	 * multiple class loaders.
	 */
	private static String _strategy = System.getProperty(
		PROPERTY_MULTIPLE_CLASS_LOADERS, MULTIPLE_CLASS_LOADERS_ERROR);

	/** Get the value of the property 
	 * {@link #PROPERTY_MULTIPLE_CLASS_LOADER} used to define the model 
	 * behavior concerning multiple class loaders.
	 * @return the value of the property, one of
	 * {@link #MULTIPLE_CLASS_LOADERS_IGNORE},
	 * {@link #MULTIPLE_CLASS_LOADERS_RELOAD}, or
	 * {@link #MULTIPLE_CLASS_LOADERS_ERROR}
	 */
	public static String getStrategy ()
	{
		return _strategy;
	}

	/** Sets the value of the property 
	 * {@link #PROPERTY_MULTIPLE_CLASS_LOADER} used to define the model 
	 * behavior concerning multiple class loaders.
	 * @param strategy the new value of the property. Value should be one of
	 * {@link #MULTIPLE_CLASS_LOADERS_IGNORE},
	 * {@link #MULTIPLE_CLASS_LOADERS_RELOAD}, or
	 * {@link #MULTIPLE_CLASS_LOADERS_ERROR}
	 * @see RuntimeModel#findClassLoader
	 */
	public static void setStrategy (String strategy)
	{
		_strategy = strategy;
	}

}
