/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FieldElementHolder.java
 *
 * Created on February 28, 2000, 3:55 PM
 */

package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.ModelException;

/** 
 *
 * @author raccah
 * @version %I%
 */
public interface FieldElementHolder
{
	/** Add the supplied field to the collection of fields maintained by this 
	 * holder.
	 * @param field the field to be added
	 * @exception ModelException if impossible
	 */
	public void addField (PersistenceFieldElement field) 
		throws ModelException;

	/** Add the supplied fields to the collection of fields maintained by this 
	 * holder.
	 * @param fields the array of fields to be added
	 * @exception ModelException if impossible
	 */
	public void addFields (PersistenceFieldElement[] fields)
		throws ModelException;

	/** Remove the supplied field from the collection of fields maintained by 
	 * this holder.
	 * @param field the field to be removed
	 * @exception ModelException if impossible
	 */
	public void removeField (PersistenceFieldElement field)
		throws ModelException;

	/** Removed the supplied fields from the collection of fields maintained 
	 * by this holder.
	 * @param fields the array of fields to be removed
	 * @exception ModelException if impossible
	 */
	public void removeFields (PersistenceFieldElement[] fields)
		throws ModelException;

	/** Returns the collection of fields maintained by this holder in the form 
	 * of an array.
	 * @return the fields maintained by this holder
	 */
	public PersistenceFieldElement[] getFields ();

	/** Sets the collection of fields maintained by this holder to the contents  
	 * of the supplied array.
	 * @param fields the fields maintained by this holder
	 * @exception ModelException if impossible
	 */
	public void setFields (PersistenceFieldElement[] fields)
		throws ModelException;

	/** Returns the field with the supplied name from the collection of fields 
	 * maintained by this holder.
	 * @param name the name to match
	 * @return the field with the supplied name, <code>null</code> if none exists
	 */
	public PersistenceFieldElement getField (String name);

	/** Tests whether the supplied field is in the collection of fields 
	 * maintained by this holder.
	 * @param field the field to be tested
	 */
	public boolean containsField (PersistenceFieldElement field);
}
