/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * InstanceCallbacks.java
 *
 * Created on February 25, 2000
 */
 
package com.sun.jdo.api.persistence.support;

/**
 *
 * @author Craig Russell
 * @version 0.1
 */

/**
 * A PersistenceCapable class that provides callback methods for life
 * cycle events implements this interface.
 *
 * <P>Classes which include derived fields (transient fields whose values depend
 * on the values of persistent fields) require callbacks on specific
 * JDO Instance life cycle events in order to correctly populate the
 * values in these fields.  
 * 
 * <P>This interface defines the methods executed
 * by the PersistenceManager for these life cycle events.  If the class
 * implements InstanceCallbacks, it must explicitly declare it in the
 * class definition.  The Reference Enhancer does not modify the declaration or
 * any of the methods in the interface.
 */
public interface InstanceCallbacks 
{
    /**
     * Called after the values are loaded from the data store into
     * this instance.
     *
     * <P>Derived fields should be initialized in this method.
     *
     * <P>This method is never modified by the Reference Enhancer.
     */
    void jdoPostLoad();

    /**
     * Called before the values are stored from this instance to the
     * data store.
     *
     * <P>Database fields that might have been affected by modified derived
     * fields should be updated in this method.
     *
     * <P>This method is never modified by the Reference Enhancer.
     */
    void jdoPreStore();

    /**
     * Called before the values in the instance are cleared.
     *
     * <P>Transient fields should be cleared in this method, as they will
     * not be affected by the jdoClear method.  Associations between this
     * instance and others in the runtime environment should be cleared.
     *
     * <P>This method is never modified by the Reference Enhancer.
     */
    void jdoPreClear();
}
