/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PersistenceCapable.java
 *
 * Created on February 28, 2000
 */
 
package com.sun.jdo.spi.persistence.support.sqlstore;


/**
 * Internal PersistenceCapable interface.
 */
public interface PersistenceCapable
    extends com.sun.jdo.api.persistence.support.PersistenceCapable
{
    /**
     * Returns the associated state manager. 
     */
    StateManager jdoGetStateManager();

    /**
     * Sets the associated state manager.
     */
    void jdoSetStateManager(StateManager sm);

    /**
     * Returns the value of the JDO flags. 
     */
    byte jdoGetFlags();

    /**
     * Sets the value of the JDO flags, and returns the previous value.
     */
    void jdoSetFlags(byte flags);

    /**
     * Returns the value of the specified field.
     *
     * Primitive valued fields are wrapped with the corresponding
     * Object wrapper type.
     */
    Object jdoGetField(int fieldNumber);

    /**
     * Sets the value of the specified field.
     *
     * Primitive valued fields are wrapped with the corresponding
     * Object wrapper type.
     */
    void jdoSetField(int fieldNumber, Object value);

    /**
     * Creates an instance of the same class as this object.
     */
    // added new method
    Object jdoNewInstance(StateManager statemanager);

    /**
     * Clears the fields of each persistent field.
     * 
     * This method stores zero or null values into each persistent
     * field of the instance, in effect reverting it to its initial
     * state. Clearing fields allows objects referred to by this
     * instance to be garbage collected. The associated StateManager
     * calls this method when transitioning an instance to the hollow
     * state. This will normally be during post completion. 
     */
    // removed parameter: StateManager sm
    void jdoClear();

    /**
     * Copies values from each transient, derived, or persistent field
     * from the target instance.
     *
     * The target instance must have exactly the same type as this instance.
     *
     * This method might be used by the StateManager to make a shallow
     * copy of an instance, or might be used to restore values of an
     * instance after transaction rollback. It might be used by the
     * application to make a shallow copy (clone) of a transient or
     * persistent instance.
     *
     * The enhancement-added fields (jdoFlags and jdoStateManager) are not
     * affected by jdoCopy(). 
     */
    //@olsen: fix 4435059: this method is not generated anymore
    // additional parameter: boolean cloneSCOs
    //void jdoCopy(Object o, boolean cloneSCOs);
}
