/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */



/*
 * PersistenceManagerServiceImpl.java
 *
 * Created on January 24, 2002
 */

package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.jdo.spi.persistence.utility.logging.LogHelper;


/**
 * This class extends the default implementation of the ServerLifecycle 
 * interface and allows to load Sun specific implementation of the
 * TransactionHelper as a part of Sun - Server Lifecycle process. 
 * This class does not need to do any processing for the Server Lifecycle events 
 * other than load the necessary class.
 */
public class PersistenceManagerServiceImpl extends ServerLifecycleImpl {

    // Initialize the appserver loggers.
    static {
        LogHelper.registerLoggerFactory(new LoggerFactoryiAS());
    }

    // Reference and force the initialization of the Sun specific 
    // implementation of the TransactionHelper and the ContainerHelper.
    private static final Class helper = forceInit(SunContainerHelper.class);

    // Reference and force the initialization of the DeploymentEventListener
    // implementation.
    private static final Class listener = 
        forceInit("com.sun.jdo.spi.persistence.support.ejb.ejbc.DeploymentEventListenerImpl");

    /**
     * Forces the initialization of the class pertaining to the specified
     * <tt>Class</tt> object. This method does nothing if the class is already
     * initialized prior to invocation.
     *
     * @param klass the class for which to force initialization
     * @return <tt>klass</tt>
     */
    private static <T> Class<T> forceInit(Class<T> klass) {
        try {
            Class.forName(klass.getName(), true, klass.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw new AssertionError(e);  // Can't happen
        }
        return klass;
    }

    private static <T> Class<T> forceInit(String klassName) {
        Class klass;
        try {
            klass = Class.forName(klassName);
        } catch (ClassNotFoundException e) {
            throw new AssertionError(e);  // Can't happen
        }
        return klass;
    }

}
