/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ResultFieldDesc.java
 *
 * Created on October 15, 2001
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql;

import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;

/**
 * This class is used to associated a field to the position of a column
 * in a JDBC resultset.
 */
public class ResultFieldDesc extends Object {
    /**
     * field descriptor for the field that is the recipient of the column value
     * from the resultset
     */
    private LocalFieldDesc fieldDesc;

    /** holds the index to the column in the resultset. */
    private ColumnRef columnRef;

    public ResultFieldDesc(LocalFieldDesc fieldDesc, ColumnRef columnRef) {
        this.fieldDesc = fieldDesc;
        this.columnRef = columnRef;
        //this.projection = projection;
    }

    /** Return the field descriptor.
     *  @return the field descriptor
     */
    public LocalFieldDesc getFieldDesc() {
        return fieldDesc;
    }

    /** Return the column reference
     *  @return the column reference
     */
    public ColumnRef getColumnRef() {
        return columnRef;
    }

}
