/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConstraintFieldName.java
 *
 * Created on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint;

import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;

/**
 */
public class ConstraintFieldName extends ConstraintField {

    public ActionDesc desc;

    public String name;

    private boolean projection;

    private final boolean prefetched;

    public ConstraintFieldName(String name,
                               ActionDesc desc) {
        super();
        this.name = name;
        this.desc = desc;
        this.prefetched = false;
    }

    public ConstraintFieldName(String name, ActionDesc desc, boolean prefetched) {
        super();
        this.name = name;
        this.desc = desc;
        // Resolve: This constructor should always be called with parameter prefetched
        // set to true. Ideally, we should have an inheritance hierachy as follows
        //              ConstraintFieldName
        //                    |
        //   ----------------------------------
        //   |                                 |
        // ProjectionFieldName         PrefetchedFieldName
        // then isPrefetched and isProjection can be turned into abstract methods
        // Till we do the cleanup, parameter prefetched will just serve as a
        // marker and its value will always be ignored.
        assert prefetched == true;
        this.prefetched = prefetched;
    }

    public boolean isProjection() {
        return projection;
    }

    public void setProjection() {
        this.projection = true;
    }

    public boolean isPrefetched() {
        return prefetched;
    }
}
