/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.*;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;

import java.sql.ResultSet;
import java.sql.SQLException;


/**
 * Implements Select Plan for verifying clean VC instanses.
 * @author Mitesh Meswani
 */
public class VerificationSelectPlan extends SelectQueryPlan {

    /**
     * Creates a new VerificationSelectQueryPlan.
     *
     * @param desc The Retrieve descriptor holding constraints
     * @param store Store manager executing the query.
     */
    public VerificationSelectPlan(RetrieveDesc desc, SQLStoreManager store) {
        super(desc, store, null);
    }

    /**
     * There are no real fields to be selected for verification query.
     * This method just adds the tables for the version field.
     */
    protected void processFields() {
        LocalFieldDesc[] versionFields = config.getVersionFields();
        for (int i = 0; i < versionFields.length; i++) {
            LocalFieldDesc versionField = versionFields[i];
            addTable(versionField);
        }
    }

    protected Statement newStatement() {
        return new SelectOneStatement(store.getVendorType(), this);
    }

    /**
     * Checks whether the resultset from a verification query contains atleast
     * one row.
     * @param pm This parameter is not used.
     * @param resultData The resultset containing result from the verification query
     * @return true if the resultset contains atleast one row false otherwise.
     * @throws SQLException
     */
    public Object getResult(PersistenceManager pm, ResultSet resultData)
            throws SQLException{
        boolean verificationSuccessfull = resultData.next();
        return Boolean.valueOf(verificationSuccessfull);
    }

}
