/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.resource.spi.work;

import java.lang.Object;
import java.lang.Runnable;
import java.lang.Exception;
import java.lang.Throwable;

/**
 * This models a <code>Work</code> instance that would be executed by a 
 * <code>WorkManager</code> upon submission.
 *
 * @version 1.0
 * @author  Ram Jeyaraman
 */
public interface Work extends Runnable {

    /**
     * The <code>WorkManager</code> might call this method to hint the
     * active <code>Work</code> instance to complete execution as soon as 
     * possible. This would be called on a seperate thread other than the
     * one currently executing the <code>Work</code> instance.
     */
    void release();
}
