/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/** InteractionSpecImpl.java 
**/

package sample;

import javax.resource.cci.InteractionSpec;

public class InteractionSpecImpl implements InteractionSpec {
  
  private String functionName;
  private int interactionVerb;

  /** A string representing the name of an EIS function **/
  public 
  void setFunctionName(String functionName) {
    this.functionName = functionName;
  }

  public
  String getFunctionName() {
    return this.functionName;
  }

  /** An integer representing the mode of interaction with an 
   *  EIS instance as specified by the InteractionSpec.
   *  Valid values are: SYNC_SEND, SYNC_SEND_RECEIVE, and
   *  SYNC_RECEIVE as defined in InteractionSpec interface.
  **/
  public
  void setInteractionVerb(int verb) {
    this.interactionVerb = verb;
  }

  public
  int getInteractionVerb() {
    return this.interactionVerb;
  }

}

