package oracle.toplink.essentials.ejb.cmp3;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceUnitInfo;

import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;

/**
 *  Utility used to statically weave entities for use in TopLink EJB 3.0
 *  
 *  The main method of this class should be invoked with the -javaagent tag to initiate weaving.
 *  
 *  The following system arguments should be provided:
 *  -javaagent:<toplink_agent_jar_location>
 *  -Dtoplink.weaving.output.path=<location_to_put_weaved_classes>
 *  -Dtoplink.validation-only=true
 *  -Dtoplink.weaving.overwrite.existing=true if you wish the output of static weaving to overwrite existing classes 
 *  
 *  Weaving will occur for all persistence units found on the classpath.
 */
public class StaticWeaver {


    /**
     *  This method will search for all of the persistence archives on the classpath and weave
     *  all the classes associated with those persistence units.
     */
    public static void main(String[] args) {
        Set<URL> urls = PersistenceUnitProcessor.findPersistenceArchives();
        Iterator<URL> urlIterator = urls.iterator();
        while (urlIterator.hasNext()){
            List<SEPersistenceUnitInfo> puInfoList = PersistenceUnitProcessor.getPersistenceUnits(urlIterator.next(), Thread.currentThread().getContextClassLoader());
            Iterator<SEPersistenceUnitInfo> puInfoListIterator = puInfoList.iterator();
            while (puInfoListIterator.hasNext()){
                Persistence.createEntityManagerFactory(puInfoListIterator.next().getPersistenceUnitName());
            }
        }
    }

}
