/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions;

import java.io.File;
import java.net.URL;

import oracle.toplink.essentials.exceptions.i18n.*;

public class PersistenceUnitLoadingException  extends TopLinkException {

    public static final int EXCEPTION_LOADING_FROM_DIRECTORY = 30001;
    public static final int EXCEPTION_LOADING_FROM_JAR = 30002;
    public static final int EXCEPTION_PROCESSING_PERSISTENCE_UNIT = 30003;
    public static final int EXCEPTION_PROCESSING_PERSISTENCE_XML = 30004;
    public static final int EXCEPTION_SEARCHING_FOR_PERSISTENCE_RESOURCES = 30005;
    public static final int EXCEPTION_SEARCHING_FOR_ENTITIES = 30006;
    public static final int EXCEPTION_LOADING_CLASS = 30007;
    public static final int FILE_PATH_MISSING_EXCEPTION = 30008;
    public static final int EXCEPTION_LOADING_FROM_URL = 30009;
    public static final int EXCEPTION_OPENING_ORM_XML = 30010;
    public static final int COULD_NOT_GET_CLASS_NAMES_FROM_URL = 30011;

    /**
     * INTERNAL:
     * TopLink exceptions should only be thrown by TopLink.
     */
    public PersistenceUnitLoadingException() {
        super();
    }

    /**
     * INTERNAL:
     * TopLink exceptions should only be thrown by TopLink.
     */
    protected PersistenceUnitLoadingException(String message) {
        super(message);
    }

    /**
     * INTERNAL:
     * TopLink exceptions should only be thrown by TopLink.
     */
    protected PersistenceUnitLoadingException(String message, Throwable internalException) {
        super(message);
        setInternalException(internalException);
    }
    
    public static PersistenceUnitLoadingException exceptionLoadingFromDirectory(File directory, Exception cause) {
        Object[] args = { directory };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_LOADING_FROM_DIRECTORY, args), cause);
        loadingException.setErrorCode(EXCEPTION_LOADING_FROM_DIRECTORY);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException filePathMissingException(String filePath) {
        Object[] args = { filePath };
        
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, FILE_PATH_MISSING_EXCEPTION, args));
        loadingException.setErrorCode(FILE_PATH_MISSING_EXCEPTION);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionLoadingFromJar(URL jarFile, Exception cause) {
        Object[] args = { jarFile };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_LOADING_FROM_JAR, args), cause);
        loadingException.setErrorCode(EXCEPTION_LOADING_FROM_JAR);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionLoadingFromUrl(String url, Exception cause) {
        Object[] args = { url };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_LOADING_FROM_URL, args), cause);
        loadingException.setErrorCode(EXCEPTION_LOADING_FROM_URL);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionProcessingPersistenceUnit(URL url, Exception cause) {
        Object[] args = { url };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_PROCESSING_PERSISTENCE_UNIT, args), cause);
        loadingException.setErrorCode(EXCEPTION_PROCESSING_PERSISTENCE_UNIT);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionProcessingPersistenceXML(URL url, Exception cause) {
        Object[] args = { url };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_PROCESSING_PERSISTENCE_XML, args), cause);
        loadingException.setErrorCode(EXCEPTION_PROCESSING_PERSISTENCE_XML);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionSearchingForPersistenceResources(ClassLoader loader, Exception cause) {
        Object[] args = { loader };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_SEARCHING_FOR_PERSISTENCE_RESOURCES, args), cause);
        loadingException.setErrorCode(EXCEPTION_SEARCHING_FOR_PERSISTENCE_RESOURCES);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionSearchingForEntities(URL url, Exception cause) {
        Object[] args = { url };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_SEARCHING_FOR_ENTITIES, args), cause);
        loadingException.setErrorCode(EXCEPTION_SEARCHING_FOR_ENTITIES);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionLoadingClassWhileLookingForAnnotations(String className, Exception cause) {
        Object[] args = { className };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_LOADING_CLASS, args), cause);
        loadingException.setErrorCode(EXCEPTION_LOADING_CLASS);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException exceptionLoadingORMXML(String fileName, Exception cause) {
        Object[] args = { fileName };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, EXCEPTION_OPENING_ORM_XML, args), cause);
        loadingException.setErrorCode(EXCEPTION_OPENING_ORM_XML);
        return loadingException;
    }
    
    public static PersistenceUnitLoadingException couldNotGetClassNamesFromUrl(URL url) {
        Object[] args = { url };

        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, COULD_NOT_GET_CLASS_NAMES_FROM_URL, args));
        loadingException.setErrorCode(COULD_NOT_GET_CLASS_NAMES_FROM_URL);
        return loadingException;
    } 
    
}
