/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 * English ResourceBundle for EntityManagerSetupException messages.
 *
 * @author: Tom Ware
 */
public class EntityManagerSetupExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "28001", "A ValidationException was thrown while trying to create session: [{0}] " + ". The most likely causes of this issue are that your [{1}] file is not available on the classpath " + "or it does not contain a session called: [{0}]." },
                                           { "28002", "TopLink is attemting to load a ServerSession named [{0}] from [{1}], and not getting a ServerSession." },
                                           { "28003", "TopLink has loaded Session [{0}] from [{1}] and it either does not have a server platform specified or specifies " + "a server platform that does not use and external transaction controller.  Please specify an appropriate server platform if you plan to use JTA." },
                                           { "28004", "Error in setup of EntityManager factory: JavaSECMPInitializer.initializeFromMain returned false." },
                                           { "28005", "An Exception was thrown in setup of EntityManager factory." },
                                           { "28006", "ClassNotFound: [{0}] specified in [{1}] property." },
                                           { "28007", "Failed to instantiate ServerPlatform of type [{0}] specified in [{1}] property." },
                                           { "28008", "Class: {0} was not found while processing annotations." },
                                           { "28009", "Attempted to redeploy a session named {0} without closing it." },
                                           { "28010", "PersistenceUnitInfo {0} has transactionType JTA, but doesn't have jtaDataSource." },
                                           { "28011", "The session, [{0}], built for a persistence unit was not available at the time it was deployed.  This means that somehow the session was removed from the container in the middle of the deployment process." },
                                           { "28012", "Value [{0}] is of incorrect type for property [{2}], value type should be [{1}]." },
                                           { "28013", "Attempted to deploy PersistenceUnit [{0}] for which predeploy method either had not called or had failed" },
                                           { "28014", "Exception was thrown while processing property [{0}] with value {[1}]." }
   };

    /**
      * Return the lookup table.
      */
    protected Object[][] getContents() {
        return contents;
    }
}
