/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

/**
 * INTERNAL:
 * Static values for metadata processing.
 */
public class MetadataConstants {
    public static final String SINGLE_TABLE = "SINGLE_TABLE";
    public static final String TABLE_PER_CLASS = "TABLE_PER_CLASS";
    
    /* Used for setting the discriminator column type. */
    public static final String CHAR = "CHAR";
    public static final String STRING = "STRING";
    public static final String INTEGER = "INTEGER";
    
    /* Used with order by. */
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";
    
    /* Used with temporal field classifications. */
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    
    /* Used for setting the xml cascade types. */
	public static final String CASCADE_ALL = "cascade-all";
    public static final String CASCADE_MERGE = "cascade-merge";
    public static final String CASCADE_REMOVE = "cascade-remove";
    public static final String CASCADE_PERSIST = "cascade-persist";
    public static final String CASCADE_REFRESH = "cascade-refresh";
    
    /* Sequencing constants. */
    public static final String AUTO = "AUTO";
    public static final String TABLE = "TABLE";
    public static final String IDENTITY = "IDENTITY";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    public static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    public static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    
    /* Relationship mappings. */
    public static final String LAZY = "LAZY";
    public static final String EAGER = "EAGER";
}
