/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumn;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataConstants;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

import oracle.toplink.essentials.internal.helper.DatabaseField;

import oracle.toplink.essentials.mappings.OneToOneMapping;

import java.util.List;

/**
 * A single object relationship accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public abstract class ObjectAccessor extends RelationshipAccessor {
    protected ObjectAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    
        // Override the following default settings from the parent.
        setIsOptional(true);
        setFetchType(MetadataConstants.EAGER);
    }
    
    /**
     * INTERNAL:
     * Initialize a OneToOneMapping.
     */
    protected OneToOneMapping initOneToOneMapping() {
    	OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setIsOptional(isOptional());
        mapping.setAttributeName(getAttributeName());
        mapping.setReferenceClassName(getReferenceClassName());
        
        // If the global weave for value holders is true, the use the value
        // from usesIndirection. Otherwise, force it to false.
        boolean usesIndirection = (m_project.enableLazyForOneToOne()) ? usesIndirection() : false;
        mapping.setUsesIndirection(usesIndirection);
        
        // Set the getter and setter methods if access is PROPERTY and the
        // mapping doesn't use indirection.
        setAccessorMethods(mapping);
        
        // Process the cascade types.
        processCascadeTypes(mapping);
        
        return mapping;
    }
    
    /**
     * INTERNAL:
     * Process the the correct metadata join column for the owning side of a 
     * one to one mapping.
     */
    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        if (isOneToOnePrimaryKeyRelationship()) {
            processOneToOnePrimaryKeyRelationship(mapping);
        } else {
            processOneToOneForeignKeyRelationship(mapping);
        }
    }
    
    /**
     * INTERNAL:
     * Process the @JoinColumn(s) for the owning side of a one to one mapping.
     * The default pk and pk field names are used only with single primary key 
     * entities. The processor should never get as far as to use them with 
     * entities that have a composite primary key (validation exception will be 
     * thrown).
     */
    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping) {         
        // If the pk field (referencedColumnName) is not specified, it 
        // defaults to the primary key of the referenced table.
        String defaultPKFieldName = getReferenceDescriptor().getPrimaryKeyFieldName();
        
        // If the fk field (name) is not specified, it defaults to the 
        // concatenation of the following: the name of the referencing 
        // relationship property or field of the referencing entity; "_"; 
        // the name of the referenced primary key column.
        String defaultFKFieldName = getUpperCaseAttributeName() + "_" + defaultPKFieldName;
            
        // Join columns will come from a @JoinColumn(s).
        List<MetadataJoinColumn> joinColumns = processJoinColumns();

        // Add the source foreign key fields to the mapping.
        for (MetadataJoinColumn joinColumn : joinColumns) {
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(getName(pkField, defaultPKFieldName, MetadataLogger.PK_COLUMN));
            pkField.setTableName(getReferenceDescriptor().getPrimaryTableName());
            
            DatabaseField fkField = joinColumn.getForeignKeyField();
            fkField.setName(getName(fkField, defaultFKFieldName, MetadataLogger.FK_COLUMN));
            // Set the table name if one is not already set.
            if (fkField.getTableName().equals("")) {
                fkField.setTableName(m_descriptor.getPrimaryTableName());
            }
            
            // Add a source foreign key to the mapping.
            mapping.addForeignKeyField(fkField, pkField);
            
            // If any of the join columns is marked read-only then set the 
            // mapping to be read only.
            if (fkField.isReadOnly()) {
                mapping.setIsReadOnly(true);
            }
        }
    }
    
    /**
     * INTERNAL:
     * Process the primary key join columns for the owning side of a one to one 
     * mapping. The default pk and pk field names are used only with single 
     * primary key entities. The processor should never get as far as to use 
     * them with entities that have a composite primary key (validation 
     * exception will be thrown).
     */
    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping mapping) {
        // Join columns will come from a @PrimaryKeyJoinColumn(s).
        MetadataDescriptor referenceDescriptor = getReferenceDescriptor();
        List<MetadataPrimaryKeyJoinColumn> primaryKeyJoinColumns = processPrimaryKeyJoinColumns(getPrimaryKeyJoinColumns(referenceDescriptor.getPrimaryTableName(), m_descriptor.getPrimaryTableName()));

        // Add the source foreign key fields to the mapping.
        for (MetadataPrimaryKeyJoinColumn primaryKeyJoinColumn : primaryKeyJoinColumns) {
            // The default primary key name is the primary key field name of the
            // referenced entity.
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(getName(pkField, referenceDescriptor.getPrimaryKeyFieldName(), m_logger.PK_COLUMN));
            
            // The default foreign key name is the primary key of the
            // referencing entity.
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(getName(fkField, m_descriptor.getPrimaryKeyFieldName(), m_logger.FK_COLUMN));
            
            // Add a source foreign key to the mapping.
            mapping.addForeignKeyField(fkField, pkField);
            
            // Mark the mapping read only
            mapping.setIsReadOnly(true);
        }
    }
    
    /**
     * INTERNAL:
     * Process the @JoinColumn(s) for the owning side of a one to one mapping.
     */
     /* SAVED
    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        // The default pk and pk field names are used only with single primary
        // key entities. The processor should never get as far as to use them
        // with entities that have a composite primary key (validation
        // exception will be thrown).
        String defaultFKFieldName;
        String defaultPKFieldName;
        List<MetadataJoinColumn> joinColumns;
        MetadataDescriptor referenceDescriptor = getReferenceDescriptor();
        
        if (isOneToOnePrimaryKeyRelationship()) {
            processOneToOnePrimaryKeyRelationship(mapping);
            
            // The same name as the primary key field of the referenced entity.
            defaultPKFieldName = referenceDescriptor.getPrimaryKeyFieldName();
            
            // The same name as the primary key field of the referencing entity.
            defaultFKFieldName = m_descriptor.getPrimaryKeyFieldName();
            
            // Join columns will come from a @PrimaryKeyJoinColumn(s).
            // Guy here
            //List<MetadataPrimaryJoinColumns> jColumns = processPrimaryKeyJoinColumns(getPrimaryKeyJoinColumns(referenceDescriptor.getPrimaryTableName(), getDescriptor().getPrimaryTableName()));
            
            joinColumns = processPrimaryKeyJoinColumns(referenceDescriptor.getPrimaryTableName(), m_descriptor.getPrimaryTableName());
        } else {
            // If the pk field (referencedColumnName) is not specified, it 
            // defaults to the primary key of the referenced table.
            defaultPKFieldName = referenceDescriptor.getPrimaryKeyFieldName();
        
            // If the fk field (name) is not specified, it defaults to the 
            // concatenation of the following: the name of the referencing 
            // relationship property or field of the referencing entity; "_"; 
            // the name of the referenced primary key column.
            defaultFKFieldName = getUpperCaseAttributeName() + "_" + defaultPKFieldName;
            
            // Join columns will come from a @JoinColumn(s).
            joinColumns = processJoinColumns();
        }

        // Add the source foreign key fields to the mapping.
        for (MetadataJoinColumn mjc : joinColumns) {
            DatabaseField pkField = mjc.getPrimaryKeyField();
            pkField.setName(getName(pkField, defaultPKFieldName, MetadataLogger.PK_COLUMN));
            
            DatabaseField fkField = mjc.getForeignKeyField();
            fkField.setName(getName(fkField, defaultFKFieldName, MetadataLogger.FK_COLUMN));
            
            // Add a source foreign key to the mapping.
            mapping.addForeignKeyField(fkField, pkField);
            
            // If this is a one to one using a primary key association, or if
            // any of the join columns is marked read-only then set the mapping
            // to be read only.
            if (isOneToOnePrimaryKeyRelationship() || fkField.isReadOnly()) {
                mapping.setIsReadOnly(true);
            }
        }
    }
     */
}
