/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;

/**
 * Object to hold onto join column metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataJoinColumns {
    protected List<MetadataJoinColumn> m_joinColumns;
    
    /**
     * INTERNAL:
     */
    public MetadataJoinColumns() {
        m_joinColumns = new ArrayList<MetadataJoinColumn>();
    }
    
    /**
     * INTERNAL:
     */
    public MetadataJoinColumns(JoinColumns joinColumns, JoinColumn joinColumn) {
        this();
        
        // Process all the join columns first.
        if (joinColumns != null) {
            for (JoinColumn jColumn : joinColumns.value()) {
                m_joinColumns.add(new MetadataJoinColumn(jColumn));
            }
        }
        
        // Process the single key join column second.
        if (joinColumn != null) {
            m_joinColumns.add(new MetadataJoinColumn(joinColumn));
        }
    }
    
    /**
     * INTERNAL:
     */
    public MetadataJoinColumns(JoinColumn[] joinColumns) {
        this();
        
        for (JoinColumn joinColumn : joinColumns) {
            m_joinColumns.add(new MetadataJoinColumn(joinColumn));
        }
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return false;
    }
    
    /**
     * INTERNAL:
     */
    public int size() {
        return m_joinColumns.size();
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataJoinColumn> values() {
        // If no join columns are specifed, add a default one.
        if (m_joinColumns.isEmpty()) {
            m_joinColumns.add(new MetadataJoinColumn());
        }
        
        return m_joinColumns;
    }
}
