/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.transaction;

/**
 * JDK 1.5 version of the EntityTransaction.  Differs from base version only in that
 * it takes a JDK 1.5 version of the EntityTransactionWrapper.
 *
 * @see oracle.toplink.essentials.internal.ejb.cmp3.transaction.EntityTransactionImpl
 */
public class EntityTransactionImpl 
    extends oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.EntityTransactionImpl
    implements javax.persistence.EntityTransaction 
{
    public EntityTransactionImpl(EntityTransactionWrapper wrapper) {
        super(wrapper);
    }       
	/**
     * Commit the current transaction, writing any un-flushed changes to the database.
     * This can only be invoked if {@link #isActive()} returns <code>true</code>.
     * @throws IllegalStateException if isActive() is false.
     * @throws PersistenceException if the commit fails.
     */
    public void commit(){
      try{
        super.commit();
      }catch (oracle.toplink.essentials.exceptions.TopLinkException tlException ) {
		//put here to avoid EJB3.0 dependencies in TopLink for jdk 1.4 
        throw new javax.persistence.RollbackException(tlException);
      }
    } 
}
