/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.columns;

import org.w3c.dom.Node;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;

/**
 * Object to hold onto xml join column metadata in a TopLink database fields.
 * 
 * @author Guy Pelletier
 * @since TopLink 10.1.3/EJB 3.0 Preview
 */
public class XMLJoinColumn extends MetadataJoinColumn {
    /**
     * INTERNAL:
     * Called for association override.
     */
    public XMLJoinColumn(Node node, XMLHelper helper) {
        // Process the primary key field metadata.
        m_pkField.setName(helper.getNodeValue(node, XMLConstants.ATT_REFERENCED_COLUMN_NAME, DEFAULT_REFERENCED_COLUMN_NAME));
        
        // Process the foreign key field metadata.
        m_fkField.setName(helper.getNodeValue(node, XMLConstants.ATT_NAME, DEFAULT_NAME));
        m_fkField.setTableName(helper.getNodeValue(node, XMLConstants.ATT_TABLE, DEFAULT_TABLE));
        m_fkField.setUnique(helper.getNodeValue(node, XMLConstants.ATT_UNIQUE, DEFAULT_UNIQUE));
        m_fkField.setNullable(helper.getNodeValue(node, XMLConstants.ATT_NULLABLE, DEFAULT_NULLABLE));
        m_fkField.setUpdatable(helper.getNodeValue(node, XMLConstants.ATT_UPDATABLE, DEFAULT_UPDATABLE));
        m_fkField.setInsertable(helper.getNodeValue(node, XMLConstants.ATT_INSERTABLE, DEFAULT_INSERTABLE));
        m_fkField.setColumnDefinition(helper.getNodeValue(node, XMLConstants.ATT_COLUMN_DEFINITION, DEFAULT_COLUMN_DEFINITION));
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return true;
    }
}
