/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.helper;


/**
 *  INTERNAL:
 *  Interface which abstracts the version of the JDK we are on.
 *  This should only implement methods that are dependant on JDK version
 *  The implementers should implement the minimum amount of functionality required to
 *  allow support of multiple versions of the JDK.
 *  @see JDK13Platform
 *  @see JDK14Platform
 *  @see JDK15Platform
 *  @see JavaPlatform
 *  @author Tom Ware
 */
public interface JDKPlatform {

    /**
     * Conforming queries with LIKE will act differently in different JDKs.
     */
    public int conformLike(Object left, Object right);

    /**
     * Get the milliseconds from a Calendar. JDK 1.4 offers a more efficient way of doing this.
     */
    public long getTimeInMillis(java.util.Calendar calendar);

    /**
     * Set the milliseconds for a Calendar. JDK 1.4 offers a more efficient way of doing this.
     */
    public void setTimeInMillis(java.util.Calendar calendar, long millis);

    /**
     * Get the Map to store the query cache in
     */
    public java.util.Map getQueryCacheMap();

    /**
     * JDK 1.4 offers the option of setting the cause of an exception
     */
    public void setExceptionCause(Throwable exception, Throwable cause);

    /**
     * Return a boolean which determines where TopLink should include the TopLink-stored
     * Internal exception in it's stack trace.  For JDK 1.4 VMs with exception chaining
     * the Internal exception can be redundant and confusing.
     */
    public boolean shouldPrintInternalException();
}
