/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;


// TopLink imports
import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Used for the EMPTY collection handling
 * <p><b>Responsibilities</b>:<ul>
 * <li> Generate the correct expression for an IS EMPTY in EJBQL
 * </ul>
 *    @author Jon Driscoll and Joel Lucuik
 *    @since August 2003
 */
public class EmptyCollectionComparisonNode extends SimpleConditionalExpressionNode {
    public boolean notIndicated = false;

    /**
     * EmptyCollectionComparisonNode constructor comment.
     */
    public EmptyCollectionComparisonNode() {
        super();
    }

    /**
     * INTERNAL
     * Validate node and calculate its type.
     */
    public void validate(ParseTreeContext context) {
        if (left != null) {
            left.validate(context);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        setType(typeHelper.getBooleanType());
    }

    /**
     * INTERNAL
     * Return a TopLink expression for this node.
     */
    public Expression generateExpression(GenerationContext context) {
        //get the variable name from the DotNode's right attribute
        //...WHERE emp.firstName IS EMPTY
        String emptyAttributeName = ((AttributeNode)getLeft().getRight()).getAttributeName();
        Expression whereClause = getLeft().getLeft().generateExpression(context);
        if (notIndicated) {
            return whereClause.notEmpty(emptyAttributeName);
        } else {
            return whereClause.isEmpty(emptyAttributeName);
        }
    }

    /**
     * INTERNAL
     * Indicate if a NOT was found in the WHERE clause.
     * Examples:
     *        ...WHERE emp.phoneNumbers IS NOT EMPTY
     */
    public void indicateNot() {
        notIndicated = true;
    }

}
