/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Represent a TRIM
 * <p><b>Responsibilities</b>:<ul>
 * <li> Generate the correct expression for TRIM
 * </ul>
 */
public class TrimNode extends StringFunctionNode {

    private Node trimChar;
    private boolean leading;
    private boolean trailing;
    private boolean both;

    /**
     * TrimNode constructor.
     */
    public TrimNode() {
        super();
    }

    /**
     * INTERNAL
     * Validate node and calculate its type.
     */
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (left != null) {
            left.validate(context);
            left.validateParameter(context, typeHelper.getStringType());
        }
        if (trimChar != null) {
            trimChar.validate(context);
            trimChar.validateParameter(context, typeHelper.getCharType());
        }
        setType(typeHelper.getStringType());
    }

    /**
     * INTERNAL
     * Generate the TopLink expression for this node
     */
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = getLeft().generateExpression(context);
        if (leading) {
            // use leftTrim
            if (trimChar != null) {
                Expression trimCharExpr = trimChar.generateExpression(context);
                whereClause = whereClause.leftTrim(trimCharExpr);
            } else {
                whereClause = whereClause.leftTrim();
            }
        } else if (trailing) {
            if (trimChar != null) {
                Expression trimCharExpr = trimChar.generateExpression(context);
                whereClause = whereClause.rightTrim(trimCharExpr);
            } else {
                whereClause = whereClause.rightTrim();
            }
        } else {
            if (trimChar != null) {
                Expression trimCharExpr = trimChar.generateExpression(context);
                whereClause = whereClause.leftTrim(trimCharExpr).rightTrim(trimCharExpr);
            } else {
                whereClause = whereClause.leftTrim().rightTrim();
            }
        }
        return whereClause;
    }

    /** */
    public void setTrimChar(Node trimChar) {
        this.trimChar = trimChar;
    }

    /** */
    public boolean isLeading() {
        return leading;
    }

    /** */
    public void setLeading(boolean newLeading) {
        this.leading = newLeading;
    }
    
    /** */
    public boolean isTrailing() {
        return trailing;
    }
    
    /** */
    public void setTrailing(boolean newTrailing) {
        this.trailing = newTrailing;
    }
    
    /** */
    public boolean isBoth() {
        return both;
    }
    
    /** */
    public void setBoth(boolean newBoth) {
        this.both = newBoth;
    }
    
}
