/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.jts.jtsxa;

import java.io.*;
import java.util.*;

import org.omg.CosTransactions.*;
import com.sun.jts.otsidl.*;
import com.sun.jts.CosTransactions.*;

/**
 * This is an Utility class containing helper functions.
 */
public class Utility {

    // static variables

    private static org.omg.CosTransactions.Current current = null;

    /*
     * All Utility methods are static.
     * It is not possible to create a JTSXA instance variable.
     */
    private Utility() {}

    /**
     * Obtain the current Control object.
     *
     * @return the current control object, or null if the Control cannot be obtained.
     * @see org.omg.CosTransactions.Control
     */
    public static Control getControl() {
        Control control = null;

        try {
            if (current == null) {
                current = (org.omg.CosTransactions.Current) Configuration.
                    getORB().resolve_initial_references("TransactionCurrent"/*#Frozen*/);
            }
            control = current.get_control();
        } catch(Exception e) {
            // empty
        }

        return control;
    }

    /**
     * Obtain the coordinator object from the supplied control.
     * <p>If a null control is supplied, an null coordinator will be returned.
     *
     * @param control the control object for which the coordinator
     *        will be returned
     *
     * @return the coordinator, or null if no coordinator can be obtained.
     *
     * @see org.omg.CosTransactions.Control
     * @see org.omg.CosTransactions.Coordinator
     */
    public static Coordinator getCoordinator(Control control) {
        Coordinator coordinator = null;

        if (control == null) {
            return null;
        }

        try {
            coordinator = control.get_coordinator();
        } catch(Exception e) {
            coordinator = null;
        }

        return coordinator;
    }

    /**
     * Obtain the global transaction identifier for the supplied coordinator.
     *
     * @param coordinator the coordinator representing the transaction for which
     *                    the global transaction identifier is required
     *
     * @return the global transaction identifier.
     *
     * @see com.sun.jts.jtsxa.XID
     */
    public static XID getXID(Coordinator coordinator) {
        otid_t tid = null;
        XID xid = new XID();

        if (coordinator == null) {
            return null;
        }

        try {
            tid = JCoordinatorHelper.narrow(coordinator).getGlobalTID();
            xid.copy(tid);
        } catch(Exception e) {
            return null;
        }

        return xid;
    }

    /**
     * Obtain the global transaction identifier for the current transaction.
     *
     * @return the global transaction identifier.
     *
     * @see com.sun.jts.jtsxa.XID
     */
    public static XID getXID() {
        Control control = null;
        Coordinator coordinator = null;

        control = getControl();
        coordinator = getCoordinator(control);

        XID xid = getXID(coordinator);

        return xid;
    }
}
