/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.jts.pi;

import org.omg.CORBA.Policy;
import org.omg.CORBA.LocalObject;

import org.omg.CosTransactions.EITHER;
import org.omg.CosTransactions.InvocationPolicy;
import org.omg.CosTransactions.INVOCATION_POLICY_TYPE;

/**
 * This is the InvocationPolicy object which holds an appropriate policy value.
 *
 * @author Ram Jeyaraman 11/11/2000
 * @version 1.0
 */
public class InvocationPolicyImpl
        extends LocalObject implements InvocationPolicy {

    private short value = EITHER.value;

    public InvocationPolicyImpl() {
        this.value = EITHER.value;
    }

    public InvocationPolicyImpl(short value) {
        this.value = value;
    }

    // org.omg.CosTransactions.InvocationPolicyOperations implementation

    public short value() {
        return this.value;
    }

    // org.omg.CORBA.PolicyOperations implementation

    public int policy_type() {
	return INVOCATION_POLICY_TYPE.value;
    }

    public Policy copy() {
	return new InvocationPolicyImpl(this.value);
    }

    public void destroy() {
	value = EITHER.value;
    }

    public String toString() {
	return "InvocationPolicy[" + this.value + "]";
    }
}
