/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.jts.pi;

import org.omg.CORBA.Any;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.LocalObject;
import org.omg.CosTransactions.REQUIRES;
import org.omg.CosTransactions.ADAPTS;
import org.omg.CosTransactions.FORBIDS;
import org.omg.CosTransactions.OTS_POLICY_TYPE;
import org.omg.CosTransactions.OTSPolicyValueHelper;
import org.omg.PortableInterceptor.PolicyFactory;

/**
 * This is the PolicyFactory to create an OTSPolicy object.
 *
 * @author Ram Jeyaraman 11/11/2000
 * @version 1.0
 */
public class OTSPolicyFactory extends LocalObject implements PolicyFactory {

    public OTSPolicyFactory() {}

    public Policy create_policy(int type, Any value) throws PolicyError {

        if (type != OTS_POLICY_TYPE.value) {
            throw new PolicyError("Invalid OTSPolicyType", (short) 0);
        }

        short policyValue = OTSPolicyValueHelper.extract(value);

        switch (policyValue) {
        case REQUIRES.value :
        case ADAPTS.value :
        case FORBIDS.value :
            break;
        default :
            throw new PolicyError("Invalid OTSPolicyValue", (short) 1);
        }

        return new OTSPolicyImpl(policyValue);
    }
}

