/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package com.sun.jts.utils;


import org.omg.CosTransactions.*;
import javax.transaction.xa.*;
import java.util.*;
import java.util.logging.*;
import java.text.*;

/**
 * This class is used to format the trace record. 
 *
 * @author <a href="mailto:k.venugopal@sun.comi,kannan.srinivasan@sun.com">K Venugopal</a>
 * @version 1.0
 */
public class LogFormatter 
{
  /**
   * Helper method to convert a byte arror to string. This is typically used for printing Xids.
   *
   * @param byteArray a <code>byte[]</code> value
   * @return a <code>String</code> value
   */
  
    public static String convertToString(byte[] byteArray)
    {
        int i;
        StringBuffer strBuf=new StringBuffer();
        for(i = 0; i < byteArray.length; i++)
         {
            strBuf.append(byteArray[i]);    
        }    
        return strBuf.toString();
    }

  /**
   * Converts an array of xids to string that can be printed. Its a helper method.
   *
   * @param xidArray a <code>Xid[]</code> value
   * @return a <code>String</code> value
   */
    public static String convertXidArrayToString(Xid[] xidArray)
    {
	if(xidArray.length != 0)
	{
        	int i;
        	StringBuffer strBuf = new StringBuffer("[ ");
        	for(i = 0; i < xidArray.length - 1; i++)
        	{
            		strBuf.append(xidArray[i].getGlobalTransactionId()).append(", ");
        	}
        	strBuf.append(xidArray[xidArray.length - 1]).append(" ]");
        	return strBuf.toString();
	}
	else
		return " null ";
    }

  /**
   * Helper method to convert properties to string.
   *
   * @param prop a <code>Properties</code> value
   * @return a <code>String</code> value
   */
    public static String convertPropsToString(Properties prop)
    {
        if(prop==null){
	    return "{null}";
        }
        StringBuffer strBuf =  new StringBuffer("{ ");
        for(Enumeration e = prop.propertyNames(); e.hasMoreElements(); )
        {
            Object obj = e.nextElement();
            strBuf.append("[ ").append(obj).append("->");
            Object val=prop.getProperty((String)obj);
            if(val==null)
	        strBuf.append("null");
            else
                strBuf.append((String)val);        
            strBuf.append(" ] ");
        }        
        strBuf.append("}");
        return strBuf.toString();
    }

	/**
	    getLocalizedMessage is used to localize the messages being used in
		exceptions
	**/

	public static String getLocalizedMessage(Logger logger , String key){
		try{
			ResourceBundle rb = logger.getResourceBundle();
			String message = rb.getString(key);
			return message;
		}catch ( Exception ex){
			logger.log(Level.FINE,"JTS:Error while localizing the log message");
			return key;
		}
	}
	
	/**
	    getLocalizedMessage is used to localize the messages being used in
		exceptions with arguments inserted appropriately.
	**/

	public static String getLocalizedMessage(Logger logger , String key,
											Object[] args){
		try{
			ResourceBundle rb = logger.getResourceBundle();
			String message = rb.getString(key);
			return MessageFormat.format(message,args);
		}catch ( Exception ex){
				logger.log(Level.FINE,"JTS:Error while localizing the log message");
			return key;
		}
	}
}
