/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */
package cal;

import java.beans.*;
import javax.servlet.http.*;
import javax.servlet.*;
import java.util.Hashtable;

public class TableBean {

  Hashtable table;
  JspCalendar JspCal;
  Entries entries;
  String date;
  String name = null;
  String email = null;
  boolean processError = false;

  public TableBean () {
    this.table = new Hashtable (10);
    this.JspCal = new JspCalendar ();
    this.date = JspCal.getCurrentDate ();
  }

  public void setName (String nm) {
    this.name = nm;
  }

  public String getName () {
    return this.name;
  }
  
  public void setEmail (String mail) {
    this.email = mail;
  }

  public String getEmail () {
    return this.email;
  }

  public String getDate () {
    return this.date;
  }

  public Entries getEntries () {
    return this.entries;
  }

  public void processRequest (HttpServletRequest request) {

    // Get the name and e-mail.
    this.processError = false;
    if (name == null || name.equals("")) setName(request.getParameter ("name"));  
    if (email == null || email.equals("")) setEmail(request.getParameter ("email"));
    if (name == null || email == null ||
		name.equals("") || email.equals("")) {
      this.processError = true;
      return;
    }

    // Get the date.
    String dateR = request.getParameter ("date");
    if (dateR == null) date = JspCal.getCurrentDate ();
    else if (dateR.equalsIgnoreCase("next")) date = JspCal.getNextDate ();
    else if (dateR.equalsIgnoreCase("prev")) date = JspCal.getPrevDate ();

    entries = (Entries) table.get (date);
    if (entries == null) {
      entries = new Entries ();
      table.put (date, entries);
    }

    // If time is provided add the event.
	String time = request.getParameter("time");
    if (time != null) entries.processRequest (request, time);
  }

  public boolean getProcessError () {
    return this.processError;
  }
}






