/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.tools.deployment.main;

import java.rmi.*;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.tools.deployment.backend.RemoteNotificationListener;

    /** I am an implementation class that listens for remote changes in the J2EE server. I delegate
    * notifications to the server manager that uses me.
    * @author Danny Coward
    */

public class ServerListener implements RemoteNotificationListener {
    private ServerManager serverManager = null;
    
	/** Construct a J2EE server listener which delegates events to the
	* supplied ServerManager instance.
	*/
    protected ServerListener(ServerManager serverManager) throws RemoteException {
	this.serverManager = serverManager;
    }

    /** implementation of the notification listener interface.*/
    public void notification(NotificationEvent ne) throws RemoteException {
	//System.out.println("server listener changed");
	try {
	    serverManager.changed();
	} catch (Throwable t) {
	    // don't want a client side exception to propogate back to the server
	    t.printStackTrace();
	}
    }

}
