/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DomainInfo.java
 *
 * Created on April 27, 2004, 3:46 PM
 */

package com.sun.enterprise.tools.upgrade.common;

/**
 *
 * @author  prakash
 */
import java.util.*;
import java.io.*;

//start CR 6396940
import org.w3c.dom.NodeList;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import javax.xml.parsers.DocumentBuilderFactory;
//end CR 6396940

public class DomainInfo {
    
    private String domainName;
    private String domainPath;
    private List instanceNames;
    private Hashtable instancePathMapping;
    
    //private CommonInfoModel commonInfo;
    /** Creates a new instance of DomainInfo */
    public DomainInfo(String dName,String dPath) {
        this.domainName = dName;
        this.domainPath = dPath;
        //this.commonInfo = cInfo;
    }
    
    /** Getter for property domainName.
     * @return Value of property domainName.
     *
     */
    public java.lang.String getDomainName() {
        return domainName;
    }    
    
    /** Setter for property domainName.
     * @param domainName New value of property domainName.
     *
     */
    public void setDomainName(java.lang.String domainName) {
        this.domainName = domainName;
    }
    
    /** Getter for property domainPath.
     * @return Value of property domainPath.
     *
     */
    public java.lang.String getDomainPath() {
        return domainPath;
    }
    
    /** Setter for property domainPath.
     * @param domainPath New value of property domainPath.
     *
     */
    public void setDomainPath(java.lang.String domainPath) {
        this.domainPath = domainPath;
    }
    
    /** Getter for property instanceNames.
     * @return Value of property instanceNames.
     * This method is only for appserver 7
     */
    public java.util.List getInstanceNames() {
        //System.out.println("DomainInfo::getInstanceNames method called.  Should be called only for source=7.x");
        if(this.instanceNames == null){
            // Only for appserver 7.x
            // Should I be getting server instance name from server.xml ???????????
            // The directory name for server instance is the name of server ?????????
            //if(commonInfo.getSourceVersion().equals(UpgradeConstants.VERSION_7X)){
                instanceNames = new ArrayList();
                instancePathMapping = new Hashtable();
                File domainDir = new File(this.domainPath);
                String [] instanceDirs = domainDir.list();
                for (int i=0 ; i<instanceDirs.length ; i++) {
                    instanceNames.add(instanceDirs[i]);
                    String instancePath= this.domainPath + File.separator + instanceDirs[i];
                    instancePathMapping.put(instanceDirs[i],instancePath);            
                }      
            //}else{
                // If it is 8.x should get the server instance names from domain.xml file.
                // Is it required now?  Only required for 8.x SE to 8.x EE upgrade
            //}
        }
        return instanceNames;
    }
    
    public String getInstancePath(String instanceName) {
        if(this.instancePathMapping == null){
            this.getInstanceNames();
        }
        // if instance path is null or "" return the domain path itself.  In case of 8.x PE
        if(instanceName == null || "".equals(instanceName.trim())){
            return this.domainPath;
        }
        return (String)this.instancePathMapping.get(instanceName);
    }
   
    //start CR 6396940
    public String getDomainApplicationRoot() {
        String configFileName = domainPath + File.separator + "config" + File.separator + "domain.xml";
	String applRoot = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((org.xml.sax.helpers.DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse( new File(configFileName));
	    NodeList domainElements = adminServerDoc.getElementsByTagName("domain");
	    //There is only one domain element
	    Element domainElement = (Element)domainElements.item(0);
	    if(domainElement != null) {
		String attrValue = domainElement.getAttribute("application-root");
                StringTokenizer attrTokens = new StringTokenizer(attrValue, "/");
		attrTokens.nextToken();
		applRoot = attrTokens.nextToken();
	    }
        }catch (Exception ex){
        }
        return applRoot;
    }
    //end CR 6396940
}
