/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Utils.java
 *
 * Created on February 11, 2004, 12:12 PM
 */

package com.sun.enterprise.tools.upgrade.gui.util;

/**
 *
 * @author  prakash
 */

import javax.help.*;

public class Utils {
    
    private static HelpBroker helpBroker ;    
    private static java.util.logging.Logger log = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.getDefaultLogger();
    /** Creates a new instance of Utils */
    public Utils() {
    }
    public static HelpBroker getHelpBroker(){
        if(helpBroker == null){
            String helpHSString = "com/sun/enterprise/tools/upgrade/doc/UpgradeToolHelp.hs";
            HelpSet helpHS = null;
            ClassLoader cl = Utils.class.getClassLoader();
            try {
                java.net.URL hsURL = HelpSet.findHelpSet(cl, helpHSString);
                helpHS = new HelpSet(null, hsURL);
            } catch (Exception ee) {
                // log messages....
                log.warning( "HelpSet " + ee.getMessage());
                log.warning("HelpSet "+ helpHS +" not found");
                return null;
            }
            // Create a HelpBroker object:
            helpBroker = helpHS.createHelpBroker();
        }
        return helpBroker;
    }
}
