/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TransactionService.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class TransactionService extends BaseElement {
    
    /** Creates a new instance of Element */
    public TransactionService() {
    }
    /**
     * element - transaction-service
     * parentSource - parent server of element
     * parentResult - domain
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        // There is always a security service in result as well as source
       NodeList transacServs = parentResult.getElementsByTagName("transaction-service");
        Element transacServ = null;
        if(transacServs.getLength() == 0){
            NodeList config = parentResult.getElementsByTagName("config");
            transacServ = parentResult.getOwnerDocument().createElement("transaction-service");
            java.util.Vector notToTransferAttrList = new java.util.Vector();
            notToTransferAttrList.add("tx-log-dir");
            this.transferAttributes(element, transacServ, notToTransferAttrList);
            this.appendElementToParent((Element)config.item(0),transacServ);  
        }else {
            transacServ = (Element)transacServs.item(0);
            java.util.Vector notToTransferAttrList = new java.util.Vector();
            notToTransferAttrList.add("tx-log-dir");
            this.transferAttributes(element, transacServ, notToTransferAttrList);
        } 
        super.transform(element,  parentSource, transacServ);
    }    
}
