/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.connector.ias;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.common.dd.connector.ResourceAdapter;
import com.sun.enterprise.tools.common.dd.connector.SunConnector;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.tools.verifier.tests.connector.*;


public class ASConnectorIdleTimeout extends ConnectorTest implements ConnectorCheck {
 public Result check(ConnectorDescriptor descriptor)
 {
     Result result = getInitializedResult();
     ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);   
	 boolean oneFailed = false;
     SunConnector sc = descriptor.getSunDescriptor();
     if(sc == null)
     {
            result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable1",
			      "NOT APPLICABLE [ASCONNECTOR]: sun-ra.xml descriptor object could not be obtained"));

     }
     else{
     ResourceAdapter ra = sc.getResourceAdapter();
     String idleTimeout = ra.getAttributeValue("idle-timeout-in-seconds");
     if(idleTimeout.length()==0)
     {
         result.failed(smh.getLocalString(getClass().getName()+".failed1",
                    "FAILED [AS-CONNECTOR resource-adapter] : idle-timeout-in-seconds cannot be empty"));
     }
     else
     {
        try
        {
            long value = Long.valueOf(idleTimeout).longValue();
            if(value < 0  || value > Long.MAX_VALUE)
            {
                result.failed(smh.getLocalString(getClass().getName()+".failed2",
                    "FAILED [AS-CONNECTOR resource-adapter] : idle-timeout-in-seconds cannot be {0}. It should be between 0 and {1}",
                new Object[]{new Long(value),new Long(Long.MAX_VALUE)}));
            }
            else
            {
                result.passed(smh.getLocalString(getClass().getName()+".passed",
                   "PASSED [AS-CONNECTOR resource-adapter] : idle-timeout-in-seconds is {0}",
                         new Object[]{new Long(value)}));
            }
        }
        catch(NumberFormatException nfex)
        {
            Verifier.debug(nfex);
            result.failed(smh.getLocalString(getClass().getName()+".failed3",
            "FAILED [AS-CONNECTOR resource-adapter] : The value {0} for idle-timeout-in-seconds is not a valid Long number",new Object[]{idleTimeout}));
        }
     }
     }
        return result;
 }
 }
