/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.miscconfig;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SunACCTransfer {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private String docType = null;
    private String secPolicyProperty = null;

    public void transform(String sourceFileName, String targetFileName) {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.configTransfers.sunacc.startMessage"));
        File sourceFile = new File(sourceFileName);
        File targetFile = new File(targetFileName);
        try {
            this.docType = this.getDOCTYPEString(targetFile);
            this.secPolicyProperty = this.getSecurityConfigValue(targetFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean renamed = targetFile.renameTo(new File(targetFileName + ".bak"));
        if (!renamed) {
            renamed = targetFile.delete();
        }
        if (renamed) {
            try {
                targetFile = new File(targetFileName);
                targetFile.createNewFile();
                this.transferFileContents(sourceFile, targetFile);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.sunacc.startFailureMessage"), ex);
            }
        } else {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.sunacc.renameFailureMessage"));
        }
    }

    private String getDOCTYPEString(File target) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(target)));
        String readLine = null;
        while ((readLine = reader.readLine()) != null) {
            if (readLine.indexOf("<!DOCTYPE") == -1) continue;
            return readLine;
        }
        return null;
    }

    private String getSecurityConfigValue(File target) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(target)));
        String readLine = null;
        while ((readLine = reader.readLine()) != null) {
            if (readLine.indexOf("<property") == -1 || readLine.indexOf("security.config") == -1) continue;
            return readLine;
        }
        return null;
    }

    private void transferFileContents(File source, File target) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
        PrintWriter writer = new PrintWriter(new FileOutputStream(target));
        String readLine = null;
        while ((readLine = reader.readLine()) != null) {
            if (readLine.indexOf("<!DOCTYPE") == -1 && readLine.indexOf("<property") == -1) {
                writer.println(readLine);
                continue;
            }
            if (readLine.indexOf("<!DOCTYPE") != -1) {
                if (this.docType != null) {
                    writer.println(this.docType);
                    continue;
                }
                writer.println();
                continue;
            }
            if (readLine.indexOf("<property") == -1) continue;
            if (readLine.indexOf("security.config") != -1) {
                if (this.secPolicyProperty != null) {
                    writer.println(this.secPolicyProperty);
                    continue;
                }
                writer.println();
                continue;
            }
            writer.println(readLine);
        }
        writer.flush();
        writer.close();
        reader.close();
    }
}

