/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ListManagementRulesCommand
extends GenericCommand {
    private static final String DEFAULT_TARGET = "server";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String config = this.resolveTargetToConfig(mbsc);
        String objectName = "com.sun.appserv:type=management-rules,config=" + config + ",category=config";
        CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
        String operationName = this.getOperationName();
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, null, null);
            this.handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private String resolveTargetToConfig(MBeanServerConnection mbsc) throws CommandException {
        String objectName = "com.sun.appserv:type=configs,category=config";
        String target = this.getOperands().size() == 1 ? (String)this.getOperands().get(0) : DEFAULT_TARGET;
        Object[] params = new Object[]{target};
        String operationName = "getConfigNameForTarget";
        String[] types = new String[]{"java.lang.String"};
        try {
            String returnValue = (String)mbsc.invoke(new ObjectName(objectName), "getConfigNameForTarget", params, types);
            return returnValue;
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
    }
}

