/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.ErrorOutputImpl;
import com.sun.enterprise.cli.framework.IErrorOutput;
import com.sun.enterprise.cli.framework.IUserInput;
import com.sun.enterprise.cli.framework.IUserOutput;
import com.sun.enterprise.cli.framework.UserInput;
import com.sun.enterprise.cli.framework.UserOutputImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputsAndOutputs {
    private static InputsAndOutputs sIO = null;
    private IUserInput userInput = new UserInput(System.in);
    private IUserOutput userOutputImpl = new UserOutputImpl(System.out, false);
    private IErrorOutput errorOutputImpl = new ErrorOutputImpl(System.err, false);

    private InputsAndOutputs() {
    }

    public static void setInstance(InputsAndOutputs iao) {
        if (iao == null) {
            if (sIO != null) {
                try {
                    InputsAndOutputs.sIO.userOutputImpl.close();
                    InputsAndOutputs.sIO.userInput.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sIO = new InputsAndOutputs();
            return;
        }
        if (iao != null && sIO != iao) {
            sIO = iao;
        }
    }

    public static InputsAndOutputs getInstance() {
        if (sIO == null) {
            sIO = new InputsAndOutputs();
        }
        return sIO;
    }

    public IUserOutput getUserOutput() {
        return this.userOutputImpl;
    }

    public void setUserOutput(OutputStream os) {
        this.userOutputImpl.close();
        this.userOutputImpl = new UserOutputImpl(os, false);
    }

    public void setUserOutputFile(String fileName) throws IOException {
        FileOutputStream userOutputFile = new FileOutputStream(fileName);
        this.userOutputImpl.close();
        this.userOutputImpl = new UserOutputImpl(userOutputFile, true);
    }

    public IUserInput getUserInput() {
        return this.userInput;
    }

    public void setUserInput(InputStream is) throws IOException {
        this.userInput.close();
        this.userInput = new UserInput(is);
    }

    public void setUserInput(InputStream is, String sEncoding) throws IOException {
        this.userInput.close();
        this.userInput = new UserInput(is);
        this.userInput.setEncoding(sEncoding);
    }

    public void setUserInput(IUserInput userInput) throws IOException {
        this.userInput.close();
        this.userInput = userInput;
    }

    public void setUserInputFile(String fileName) throws IOException {
        FileInputStream userInputFile = new FileInputStream(fileName);
        this.setUserInput(userInputFile);
    }

    public void setUserInputFile(String fileName, String sEncoding) throws IOException {
        FileInputStream userInputFile = new FileInputStream(fileName);
        this.setUserInput(userInputFile, sEncoding);
    }

    public IErrorOutput getErrorOutput() {
        return this.errorOutputImpl;
    }

    public void setErrorOutput(OutputStream os) {
        this.errorOutputImpl.close();
        this.errorOutputImpl = new ErrorOutputImpl(os, false);
    }

    public void setErrorOutputFile(String fileName) throws IOException {
        FileOutputStream errorOutputFile = new FileOutputStream(fileName);
        this.errorOutputImpl.close();
        this.errorOutputImpl = new ErrorOutputImpl(errorOutputFile, true);
    }
}

