/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.TimeBase;
import com.sun.web.ui.model.ClockTime;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;

public class Time
extends TimeBase
implements NamingContainer {
    public static final String HOUR_FACET = "hour";
    public static final String MINUTES_FACET = "minutes";
    private static final String TIME_SUBMITTED = "com.sun.web.ui.TimeSubmitted";
    private static final boolean DEBUG = false;
    private String hourTooltipKey;
    private String minutesTooltipKey;

    public DropDown getHourMenu() {
        return this.getMenu(HOUR_FACET, this.getHourItems());
    }

    public DropDown getMinutesMenu() {
        return this.getMenu(MINUTES_FACET, this.getMinuteItems());
    }

    private DropDown getMenu(String facet, Option[] options) {
        int tindex;
        DropDown menu = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, facet, true);
        if (menu == null) {
            menu = new DropDown();
            menu.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facet));
            menu.setItems(options);
            menu.setConverter((Converter)new IntegerConverter());
            ComponentUtilities.putPrivateFacet((UIComponent)this, facet, (UIComponent)menu);
        }
        if ((tindex = this.getTabIndex()) > 0) {
            menu.setTabIndex(tindex);
        }
        menu.setDisabled(this.isDisabled());
        menu.setRequired(this.isRequired());
        return menu;
    }

    private Option[] getHourItems() {
        int counter;
        Option[] hours = new Option[25];
        hours[0] = new Option(new Integer(-1), " ");
        for (counter = 0; counter < 10; ++counter) {
            hours[counter + 1] = new Option(new Integer(counter), "0" + counter);
        }
        while (counter < 24) {
            hours[counter + 1] = new Option(new Integer(counter), String.valueOf(counter));
            ++counter;
        }
        return hours;
    }

    private Option[] getMinuteItems() {
        Option[] minutes = new Option[13];
        minutes[0] = new Option(new Integer(-1), " ");
        minutes[1] = new Option(new Integer(0), "00");
        minutes[2] = new Option(new Integer(5), "05");
        for (int i = 2; i < 12; ++i) {
            minutes[i + 1] = new Option(new Integer(5 * i), String.valueOf(5 * i));
        }
        return minutes;
    }

    public String getOffset() {
        Calendar calendar = this.getCalendar();
        TimeZone timeZone = calendar.getTimeZone();
        StringBuffer gmtTimeZone = new StringBuffer(8);
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            gmtTimeZone.append('-');
            value = -value;
        } else {
            gmtTimeZone.append('+');
        }
        int num = value / 3600000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num).append(":");
        num = value % 3600000 / 60000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num);
        return gmtTimeZone.toString();
    }

    public Calendar getCalendar() {
        TimeZone timeZone;
        Calendar calendar = null;
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        if (locale == null) {
            locale = locale.getDefault();
        }
        calendar = (timeZone = this.getTimeZone()) == null ? Calendar.getInstance(locale) : Calendar.getInstance(timeZone, locale);
        return calendar;
    }

    public String getHourTooltipKey() {
        return this.hourTooltipKey;
    }

    public void setHourTooltipKey(String hourTooltipKey) {
        this.hourTooltipKey = hourTooltipKey;
    }

    public String getMinutesTooltipKey() {
        return this.minutesTooltipKey;
    }

    public void setMinutesTooltipKey(String minutesTooltipKey) {
        this.minutesTooltipKey = minutesTooltipKey;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        ComponentUtilities.getPrivateFacet((UIComponent)this, HOUR_FACET, false).processDecodes(context);
        ComponentUtilities.getPrivateFacet((UIComponent)this, MINUTES_FACET, false).processDecodes(context);
        this.setSubmittedValue(TIME_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object hourValue = ((EditableValueHolder)ComponentUtilities.getPrivateFacet((UIComponent)this, HOUR_FACET, false)).getValue();
        Object minuteValue = ((EditableValueHolder)ComponentUtilities.getPrivateFacet((UIComponent)this, MINUTES_FACET, false)).getValue();
        ClockTime newValue = null;
        try {
            newValue = this.createClockTime(hourValue, minuteValue, context);
        }
        catch (ConverterException ce) {
            FacesMessage message = ce.getFacesMessage();
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.renderResponse();
        }
        catch (Exception ex) {
            FacesMessage message = new FacesMessage("Invalid input");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.renderResponse();
        }
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, (Object)newValue));
            }
        }
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClockTime createClockTime(Object hourObject, Object minuteObject, FacesContext context) {
        String messageKey = null;
        ClockTime time = null;
        if (hourObject instanceof Integer && minuteObject instanceof Integer) {
            int hour = (Integer)hourObject;
            int minute = (Integer)minuteObject;
            if (hour == -1 && minute == -1) {
                if (!this.isRequired()) return null;
                messageKey = "Time.required";
            } else if (hour == -1) {
                messageKey = "Time.enterHour";
            } else if (minute == -1) {
                messageKey = "Time.enterMinute";
            } else {
                time = new ClockTime();
                try {
                    time.setHour(new Integer(hour));
                    time.setMinute(new Integer(minute));
                }
                catch (Exception ex) {
                    messageKey = "Time.invalidData";
                }
            }
        } else {
            if (!this.isRequired()) return null;
            messageKey = "Time.required";
        }
        if (messageKey == null) return time;
        String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
        throw new ConverterException(new FacesMessage(message));
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        String rendererType;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        DropDown hourMenu = this.getHourMenu();
        DropDown minuteMenu = this.getMinutesMenu();
        if (this.getSubmittedValue() == null) {
            Object object = this.getValue();
            ClockTime value = null;
            if (object != null && object instanceof ClockTime) {
                value = (ClockTime)object;
            }
            if (value != null) {
                hourMenu.setValue(value.getHour());
            } else {
                hourMenu.setValue(new Integer(-1));
            }
            if (value != null) {
                minuteMenu.setValue(value.getMinute());
            } else {
                minuteMenu.setValue(new Integer(-1));
            }
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String key = this.getHourTooltipKey();
        if (key != null) {
            hourMenu.setToolTip(theme.getMessage(key));
        }
        if ((key = this.getMinutesTooltipKey()) != null) {
            minuteMenu.setToolTip(theme.getMessage(key));
        }
        if ((rendererType = this.getRendererType()) != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
    }
}

