/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.inbound.EndpointConsumer;
import com.sun.genericra.inbound.InboundJmsResource;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.StringManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;

public class InboundJmsResourcePool
implements ServerSessionPool {
    private ArrayList resources;
    private EndpointConsumer consumer;
    private int maxSize;
    private int connectionsInUse = 0;
    private long maxWaitTime;
    private Connection con = null;
    private Connection dmdCon = null;
    private ConnectionFactory cf = null;
    private boolean transacted = false;
    private boolean destroyed = false;
    private boolean stopped = false;
    private LinkedList waitQ = null;
    private long TIME_OUT = 180000L;
    private static Logger _logger = LogUtils.getLogger();
    private StringManager sm = StringManager.getManager(GenericJMSRA.class);

    public InboundJmsResourcePool(EndpointConsumer consumer, boolean transacted) {
        this.consumer = consumer;
        this.transacted = transacted;
        this.waitQ = new LinkedList();
    }

    public synchronized void initialize() throws ResourceException {
        try {
            this.resources = new ArrayList();
            this.maxSize = this.consumer.getSpec().getMaxPoolSize();
            this.maxWaitTime = this.consumer.getSpec().getMaxWaitTime() * 1000;
            if (this.consumer.getSpec().getSupportsXA()) {
                XAConnectionFactory xacf = (XAConnectionFactory)this.consumer.getConnectionFactory();
                this.con = this.createXAConnection(xacf);
                ConnectionFactory cf = (ConnectionFactory)this.consumer.getDmdConnectionFactory();
                if (this.consumer.getSpec().getSendBadMessagesToDMD()) {
                    this.dmdCon = this.createDmdConnection(cf);
                }
            } else {
                if (!(this.consumer.getConnectionFactory() instanceof ConnectionFactory)) {
                    String msg = this.sm.getString("classtype_not_correct", this.consumer.getConnectionFactory().getClass().getName());
                    throw new ResourceException(msg);
                }
                this.cf = (ConnectionFactory)this.consumer.getConnectionFactory();
                this.con = this.createConnection(this.cf);
            }
            this.stopped = false;
        }
        catch (JMSException e) {
            throw ExceptionUtils.newResourceException(e);
        }
    }

    public EndpointConsumer getConsumer() {
        return this.consumer;
    }

    public Connection getConnection() {
        return this.con;
    }

    public Connection getConnectionForDMD() {
        return this.dmdCon;
    }

    public InboundJmsResource create() throws JMSException {
        _logger.log(Level.FINER, "Creating the ServerSession");
        Session sess = null;
        XAResource xar = null;
        if (this.transacted) {
            sess = this.createXASession((XAConnection)this.con);
            xar = this.getXAResource((XASession)sess);
            _logger.log(Level.FINE, "Created new XA ServerSession");
        } else {
            sess = this.createSession(this.con);
            _logger.log(Level.FINE, "Created new ServerSession");
        }
        return new InboundJmsResource(sess, this, xar);
    }

    XAConnection createXAConnection(XAConnectionFactory xacf) throws JMSException {
        Object xac = null;
        String user = this.consumer.getSpec().getUserName();
        String password = this.consumer.getSpec().getPassword();
        xac = this.isQueue() ? ((XAQueueConnectionFactory)xacf).createXAQueueConnection(user, password) : (this.isTopic() ? ((XATopicConnectionFactory)xacf).createXATopicConnection(user, password) : xacf.createXAConnection(user, password));
        return xac;
    }

    XASession createXASession(XAConnection con) throws JMSException {
        Object result = null;
        result = this.isQueue() ? ((XAQueueConnection)con).createXAQueueSession() : (this.isTopic() ? ((XATopicConnection)con).createXATopicSession() : con.createXASession());
        return result;
    }

    private XAResource getXAResource(XASession session) throws JMSException {
        XAResource result = null;
        result = this.isTopic() ? ((XATopicSession)session).getXAResource() : (this.isQueue() ? ((XAQueueSession)session).getXAResource() : session.getXAResource());
        return result;
    }

    Connection createConnection(ConnectionFactory cf) throws JMSException {
        Object con = null;
        String user = this.consumer.getSpec().getUserName();
        String password = this.consumer.getSpec().getPassword();
        con = this.isTopic() ? ((TopicConnectionFactory)cf).createTopicConnection(user, password) : (this.isQueue() ? ((QueueConnectionFactory)cf).createQueueConnection(user, password) : cf.createConnection(user, password));
        return con;
    }

    Session createSession(Connection con) throws JMSException {
        Object sess = null;
        sess = this.isTopic() ? ((TopicConnection)con).createTopicSession(false, 1) : (this.isQueue() ? ((QueueConnection)con).createQueueSession(false, 1) : con.createSession(false, 1));
        return sess;
    }

    ConnectionConsumer createConnectionConsumer(Destination dest, String name, int maxMessages) throws JMSException {
        ConnectionConsumer consumer = null;
        Connection con = this.getConnection();
        consumer = this.isTopic() ? ((TopicConnection)con).createConnectionConsumer((Topic)dest, name, (ServerSessionPool)this, maxMessages) : (this.isQueue() ? ((QueueConnection)con).createConnectionConsumer((Queue)dest, name, (ServerSessionPool)this, maxMessages) : con.createConnectionConsumer(dest, name, (ServerSessionPool)this, maxMessages));
        return consumer;
    }

    Connection createDmdConnection(ConnectionFactory cf) throws JMSException {
        Object con = null;
        String user = this.consumer.getSpec().getUserName();
        String password = this.consumer.getSpec().getPassword();
        con = this.consumer.getSpec().getDeadMessageDestinationType().equals("javax.jms.Topic") ? ((TopicConnectionFactory)cf).createTopicConnection(user, password) : (this.consumer.getSpec().getDeadMessageDestinationType().equals("javax.jms.Queue") ? ((QueueConnectionFactory)cf).createQueueConnection(user, password) : cf.createConnection(user, password));
        return con;
    }

    private boolean isTopic() {
        return this.consumer.getSpec().getDestinationType().equals("javax.jms.Topic");
    }

    private boolean isQueue() {
        return this.consumer.getSpec().getDestinationType().equals("javax.jms.Queue");
    }

    public ServerSession getServerSession() throws JMSException {
        InboundJmsResource result = null;
        PauseObject obj = null;
        while (result == null) {
            this.validate();
            result = this._getServerSession();
            if (result != null || this.maxWaitTime < 0L) continue;
            if (obj == null) {
                obj = new PauseObject();
            }
            obj.pauseCallingThread();
        }
        return result.refreshListener();
    }

    public void validate() throws JMSException {
        if (this.destroyed) {
            String msg = this.sm.getString("serversession_pool_destroyed");
            throw new JMSException(msg);
        }
    }

    private synchronized InboundJmsResource _getServerSession() throws JMSException {
        _logger.log(Level.FINER, "JMS provider is getting the ServerSession");
        if (this.stopped) {
            return null;
        }
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            InboundJmsResource resource = (InboundJmsResource)it.next();
            if (!resource.isFree()) continue;
            ++this.connectionsInUse;
            return resource.markAsBusy();
        }
        if (this.resources.size() < this.maxSize) {
            InboundJmsResource res = this.create();
            this.resources.add(res);
            ++this.connectionsInUse;
            return res.markAsBusy();
        }
        return null;
    }

    public synchronized void put(InboundJmsResource resource) {
        resource.markAsFree();
        --this.connectionsInUse;
        if (this.stopped) {
            if (this.connectionsInUse <= 0) {
                this.notify();
            }
        } else {
            this.resumeWaitingThread();
        }
    }

    public void stop() throws JMSException {
        this.stopped = true;
        this.maxWaitTime = 0L;
        this.waitForAll();
        this.releaseAllResources();
        if (this.dmdCon != null) {
            this.dmdCon.close();
        }
    }

    public void destroy() throws JMSException {
        this.destroyed = true;
        this.stop();
        this.releaseAllWaitingThreads();
    }

    public synchronized void waitForAll() {
        if (this.connectionsInUse > 0) {
            _logger.log(Level.FINE, "Waiting for " + this.connectionsInUse + " ServerSessions" + " to come back to pool");
            try {
                this.wait(this.TIME_OUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void releaseAllWaitingThreads() {
        Iterator it = this.waitQ.iterator();
        int count = 0;
        while (it.hasNext()) {
            PauseObject obj = (PauseObject)it.next();
            obj.resume();
            ++count;
        }
        _logger.log(Level.FINE, "Released a total of " + count + " requests");
    }

    public void releaseAllResources() {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            InboundJmsResource obj = (InboundJmsResource)it.next();
            obj.destroy();
        }
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWaitingThread() {
        PauseObject obj = null;
        LinkedList linkedList = this.waitQ;
        synchronized (linkedList) {
            if (this.waitQ.size() > 0) {
                obj = (PauseObject)this.waitQ.removeFirst();
            }
        }
        if (obj != null) {
            obj.resume();
        }
    }

    class PauseObject {
        long startTime = 0L;
        long elapsedWaitTime = 0L;
        long remainingWaitTime = 0L;

        PauseObject() {
        }

        void pauseCallingThread() throws JMSException {
            if (InboundJmsResourcePool.this.maxWaitTime == 0L) {
                this.remainingWaitTime = 0L;
                this.startTime = 0L;
            } else {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                this.elapsedWaitTime = this.startTime - System.currentTimeMillis();
                if (this.elapsedWaitTime > InboundJmsResourcePool.this.maxWaitTime) {
                    String msg = InboundJmsResourcePool.this.sm.getString("pool_limit_reached");
                    throw new JMSException(msg);
                }
                this.remainingWaitTime = this.startTime - this.elapsedWaitTime;
            }
            this.pause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void pause() {
            LinkedList linkedList = InboundJmsResourcePool.this.waitQ;
            synchronized (linkedList) {
                InboundJmsResourcePool.this.waitQ.addLast(this);
            }
            try {
                _logger.log(Level.FINE, "Waiting for :" + this.remainingWaitTime);
                this.wait(this.remainingWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            linkedList = InboundJmsResourcePool.this.waitQ;
            synchronized (linkedList) {
                InboundJmsResourcePool.this.waitQ.remove(this);
            }
        }

        synchronized void resume() {
            _logger.log(Level.FINE, "Notifying the thread");
            this.notify();
        }
    }
}

