/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.RequestStartTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestStartAccessObjectImpl
extends AbstractTableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static RequestStartAccessObjectImpl _singletonRS;

    private RequestStartAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        this.tableName = "REQUEST_START_TBL" + serverName.toUpperCase();
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(" INSERT INTO REQUEST_START_TBL VALUES  (  ?, ? , ? , ? , ? ) ", "REQUEST_START_TBL");
        return newsql;
    }

    public String getDeleteSQL() {
        String newsql = super.updateSqlWithTableName(" DELETE  FROM REQUEST_START_TBL WHERE REQUEST_ID =  ? ", "REQUEST_START_TBL");
        return newsql;
    }

    public boolean dropTable(Connection connection) {
        this.con = connection;
        return super.createStatmentAndExecuteUpdate("drop table REQUEST_START_TBL", "REQUEST_START_TBL");
    }

    public boolean createTable(Connection connection) {
        this.con = connection;
        return super.createTable(" create table REQUEST_START_TBL ( REQUEST_ID VARCHAR(255)  NOT NULL  , TIME_STAMP BIGINT  , TIME_STAMP_MILLIS BIGINT  , REQUEST_TYPE VARCHAR(25)  , IP_ADDRESS VARCHAR (15)  ,  primary key (REQUEST_ID))", "REQUEST_START_TBL");
    }

    public static TableAccessObject getInstance() {
        if (_singletonRS == null) {
            _singletonRS = new RequestStartAccessObjectImpl();
        }
        return _singletonRS;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] requestStart) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < requestStart.length; ++i) {
                RequestStartTO request = (RequestStartTO)requestStart[i];
                pstmt.setString(1, request.getRequestId());
                pstmt.setLong(2, request.getTimeStamp());
                pstmt.setLong(3, request.getTimeStampMillis());
                if (request.getRequestType() != null) {
                    pstmt.setString(4, request.getRequestType().toString());
                } else {
                    pstmt.setString(4, null);
                }
                if (request.getIpAddress() != null) {
                    pstmt.setString(5, request.getIpAddress());
                } else {
                    pstmt.setString(5, null);
                }
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            boolean bl = result = updated.length == requestStart.length;
            if (!result) {
                logger.log(Level.WARNING, "callflow.error_insert_row");
            }
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }
}

