/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.config.impl;

import com.sun.enterprise.admin.wsmgmt.config.impl.TransformationRuleImpl;
import com.sun.enterprise.admin.wsmgmt.config.spi.RegistryLocation;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.config.serverbeans.TransformationRule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class WebServiceConfigImpl
implements WebServiceConfig {
    String name = null;
    String monitoringLevel = null;
    boolean jbiEnabled = false;
    int maxHistorySize = 0;
    TransformationRule[] tRules = null;

    public WebServiceConfigImpl(String n, String level, int size, boolean jbi) {
        this.name = n;
        this.monitoringLevel = level;
        this.maxHistorySize = size;
        this.jbiEnabled = jbi;
    }

    public WebServiceConfigImpl(WebServiceEndpoint wsEp) {
        if (wsEp == null) {
            return;
        }
        this.name = wsEp.getName();
        this.monitoringLevel = wsEp.getMonitoring();
        this.maxHistorySize = Integer.parseInt(wsEp.getMaxHistorySize());
        this.jbiEnabled = wsEp.isJbiEnabled();
        this.tRules = wsEp.getTransformationRule();
    }

    public String getName() {
        return this.name;
    }

    public String getEndpointName() {
        StringTokenizer strTok = new StringTokenizer(this.name, "#");
        String relId = null;
        while (strTok.hasMoreElements()) {
            relId = (String)strTok.nextElement();
        }
        return relId;
    }

    public String getMonitoringLevel() {
        return this.monitoringLevel;
    }

    public int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public boolean getJbiEnabled() {
        return this.jbiEnabled;
    }

    public com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] getTransformationRule() {
        if (this.tRules != null) {
            com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] transformRules = new TransformationRuleImpl[this.tRules.length];
            for (int index = 0; index < this.tRules.length; ++index) {
                transformRules[index] = new TransformationRuleImpl(this.tRules[index]);
            }
            return transformRules;
        }
        return null;
    }

    public com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] getRequestTransformationRule() {
        if (this.tRules != null) {
            ArrayList<TransformationRuleImpl> tList = new ArrayList<TransformationRuleImpl>();
            for (int index = 0; index < this.tRules.length; ++index) {
                String phase = this.tRules[index].getApplyTo();
                if (!phase.equals("request") && !phase.equals("both") || !this.tRules[index].isEnabled()) continue;
                tList.add(new TransformationRuleImpl(this.tRules[index]));
            }
            if (tList.size() > 0) {
                TransformationRuleImpl[] transformRules = new TransformationRuleImpl[tList.size()];
                return tList.toArray(transformRules);
            }
            return null;
        }
        return null;
    }

    public com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] getResponseTransformationRule() {
        if (this.tRules != null) {
            ArrayList<TransformationRuleImpl> tList = new ArrayList<TransformationRuleImpl>();
            for (int index = 0; index < this.tRules.length; ++index) {
                String phase = this.tRules[index].getApplyTo();
                if (!phase.equals("response") && !phase.equals("both") || !this.tRules[index].isEnabled()) continue;
                tList.add(new TransformationRuleImpl(this.tRules[index]));
            }
            if (tList.size() > 0) {
                TransformationRuleImpl[] transformRules = new TransformationRuleImpl[tList.size()];
                return tList.toArray(transformRules);
            }
            return null;
        }
        return null;
    }

    public RegistryLocation[] getRegistryLocation() {
        return null;
    }
}

