/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.management.j2ee.J2EELogicalServerImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldClusterMBean;
import com.sun.enterprise.management.support.oldconfig.OldClustersMBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2EEClusterImpl
extends J2EELogicalServerImplBase {
    public J2EEClusterImpl(Delegate delegate) {
        super("X-J2EECluster", delegate);
    }

    public String[] getServerNames() {
        return this.getOldClusterMBean().listServerInstancesAsString(false);
    }

    public Map<String, ObjectName> getServerObjectNameMap() {
        Set<String> serverNamesInCluster = GSetUtil.newStringSet(this.getServerNames());
        if (serverNamesInCluster.size() == 0) {
            return Collections.emptyMap();
        }
        Set<ObjectName> allJ2EEServerObjectNames = this.getQueryMgr().queryJ2EETypeObjectNameSet("J2EEServer");
        Map<String, ObjectName> objectNameMap = Util.createObjectNameMap(allJ2EEServerObjectNames);
        HashMap<String, ObjectName> serverObjectNameMap = new HashMap<String, ObjectName>(serverNamesInCluster.size());
        for (String nameKey : serverNamesInCluster) {
            serverObjectNameMap.put(nameKey, objectNameMap.get(nameKey));
        }
        return serverObjectNameMap;
    }

    @Override
    public boolean isstateManageable() {
        return true;
    }

    @Override
    public void start() {
        this.trace("J2EEClusterImpl.start");
        this.getOldClusterMBean().start();
        this.setstartTime(System.currentTimeMillis());
    }

    @Override
    public void startRecursive() {
        this.start();
    }

    @Override
    public void stop() {
        this.trace("J2EEClusterImpl.start");
        this.getOldClusterMBean().stop();
        this.setstartTime(0L);
    }

    @Override
    public int getstate() {
        RuntimeStatusList rsl = this.getRuntimeStatus();
        int state = rsl.anyRunning() ? 1 : 3;
        return state;
    }

    private OldClusterMBean getOldClusterMBean() {
        return this.getOldConfigProxies().getOldClusterMBean(this.getSelfName());
    }

    private RuntimeStatusList getRuntimeStatus() {
        OldClustersMBean oldMBean = this.getOldConfigProxies().getOldClustersMBean();
        return (RuntimeStatusList)oldMBean.getRuntimeStatus(this.getSelfName());
    }
}

