/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.management.support.AMXMBeanRootLogger;
import com.sun.enterprise.management.support.AMXServerLogger;
import javax.management.ObjectName;

public final class BootUtil {
    private final String mAppserverDomainName;
    private final String mAMX_JMXDomain;
    private static BootUtil INSTANCE = null;
    private boolean mAMXReady;
    private final boolean mOfflineAMX;

    private BootUtil(String appserverDomainName, boolean offline) {
        AMXServerLogger.getInstance();
        AMXMBeanRootLogger.getInstance();
        this.mAppserverDomainName = appserverDomainName;
        this.mAMX_JMXDomain = appserverDomainName;
        this.mAMXReady = false;
        this.mOfflineAMX = offline;
    }

    public String getServerName() {
        return AdminService.getAdminService().getAdminContext().getServerName();
    }

    public static synchronized void init(boolean offline) {
        INSTANCE = new BootUtil("amx", offline);
    }

    public boolean getOffline() {
        return this.mOfflineAMX;
    }

    public static synchronized BootUtil getInstance() {
        if (INSTANCE == null) {
            throw new IllegalArgumentException("must call init() first");
        }
        return INSTANCE;
    }

    public boolean getAMXReady() {
        return this.mAMXReady;
    }

    public void setAMXReady(boolean ready) {
        if (this.mAMXReady && !ready) {
            throw new IllegalArgumentException();
        }
        this.mAMXReady = ready;
    }

    private ObjectName getObjectName(String props) {
        String domain = this.getAMXSupportJMXDomain();
        return Util.newObjectName(domain, props);
    }

    public String getAMXSupportJMXDomain() {
        return this.getAMXJMXDomainName() + "-support";
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    public String getAMXJMXDomainName() {
        return this.mAMX_JMXDomain;
    }
}

