/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AMXRootLogger;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.util.jmx.NotificationListenerBase;
import com.sun.enterprise.management.support.LoadBalancerApplicationRefRegistrationListener;
import com.sun.enterprise.management.support.LoadBalancerClusterRefRegistrationListener;
import com.sun.enterprise.management.support.LoadBalancerRegistrationListener;
import com.sun.enterprise.management.support.LoadBalancerServerRefRegistrationListener;
import com.sun.enterprise.management.support.ObjectNames;
import java.io.IOException;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;

public class LBBootstrapUtil
extends NotificationListenerBase {
    static final String MONITORING_ENABLED = "MonitoringEnabled";
    static boolean isInitialized = false;
    LoadBalancerRegistrationListener lbrl = null;
    private final ObjectNames objectNames = ObjectNames.getInstance("amx");

    public LBBootstrapUtil(ObjectName domainRoot, MBeanServer mBeanServer) throws InstanceNotFoundException, IOException {
        super(mBeanServer, domainRoot, null);
    }

    public void handleNotification(Notification notifIn, Object handback) {
        try {
            String type = notifIn.getType();
            if (type == null || !type.equals("com.sun.appserv.management.DomainRoot.AMXReady")) {
                return;
            }
            if (isInitialized) {
                return;
            }
            this.lbrl = new LoadBalancerRegistrationListener((MBeanServer)this.getConn());
            this.initRestOfLBMBeanRegistrationListeners();
            DomainConfig domainConfig = ProxyFactory.getInstance(this.getConn()).getDomainRoot().getDomainConfig();
            Map<String, LoadBalancerConfig> loadBalancerConfigMap = domainConfig.getLoadBalancerConfigMap();
            Map<String, LBConfig> lbConfigMap = domainConfig.getLBConfigMap();
            String lbConfigName = null;
            LBConfig lbConfig = null;
            String loadBalancerName = null;
            boolean isMonitoringEnabled = false;
            for (LoadBalancerConfig loadBalancerConfig : loadBalancerConfigMap.values()) {
                loadBalancerName = loadBalancerConfig.getName();
                lbConfigName = loadBalancerConfig.getLbConfigName();
                lbConfig = lbConfigMap.get(lbConfigName);
                LoadBalancer loadBalancer = this.lbrl.registerLoadBalancer(loadBalancerConfig.getName());
                isMonitoringEnabled = lbConfig.getMonitoringEnabled();
                if (isMonitoringEnabled) {
                    this.lbrl.enableMonitoring(loadBalancerConfig.getName(), lbConfig);
                }
                this.lbrl.addLBConfigListener(loadBalancerName, lbConfig);
            }
            isInitialized = true;
        }
        catch (Exception ex) {
            AMXRootLogger.getInstance().warning("LBBootstrapUtil:handleNotification : " + ex.getMessage());
        }
    }

    private void initRestOfLBMBeanRegistrationListeners() {
        MBeanServer mbeanServer = (MBeanServer)this.getConn();
        try {
            new LoadBalancerClusterRefRegistrationListener(mbeanServer);
            new LoadBalancerServerRefRegistrationListener(mbeanServer);
            new LoadBalancerApplicationRefRegistrationListener(mbeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

