/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.Output;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateToMBeanDelegate;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.TypeInfo;
import com.sun.enterprise.management.support.TypeInfos;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LoaderOfOld {
    protected final Loader mLoader;
    private final Output mDebug;
    private static final Class[] EMPTY_SIG = new Class[0];
    private static final Class[] DELEGATE_SIG = new Class[]{Delegate.class};

    LoaderOfOld(Loader loader) {
        this.mLoader = loader;
        this.mDebug = AMXDebug.getInstance().getOutput(this.getClass().getName());
    }

    protected final void debug(Object o) {
        this.mDebug.println(o.toString());
    }

    protected abstract Set<ObjectName> findAllOldCandidates();

    protected DomainRoot getDomainRoot() {
        return this.mLoader.getDomainRoot();
    }

    protected abstract Set getNeedsSupport();

    protected abstract Set getIgnoreTypes();

    protected abstract boolean isOldMBean(ObjectName var1);

    public final boolean shouldSync(ObjectName o) {
        boolean shouldSync = this.isOldMBean(o);
        if (shouldSync) {
            String type = o.getKeyProperty("type");
            if (this.getNeedsSupport().contains(type)) {
                shouldSync = false;
                this.getLogger().warning("com.sun.appserv MBean not yet supported: " + StringUtil.quote(o));
            } else if (this.isDefectiveIgnore(o)) {
                shouldSync = false;
                this.debug("com.sun.appserv MBean was last determined to be defective and will not be represented in AMX: " + StringUtil.quote(o));
            }
        }
        return shouldSync;
    }

    protected boolean isDefectiveIgnore(ObjectName objectName) {
        return false;
    }

    public final List findAllOld() {
        Set<ObjectName> all = this.findAllOldCandidates();
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        for (ObjectName objectName : all) {
            if (!this.shouldSync(objectName)) continue;
            results.add(objectName);
        }
        return ListUtil.newListFromCollection(results);
    }

    protected abstract ObjectName oldToNewObjectName(ObjectName var1);

    protected final Map<String, Set<ObjectName>> candidatesToMap(Set<ObjectName> candidates, String key) {
        HashMap<String, Set<ObjectName>> setMap = new HashMap<String, Set<ObjectName>>();
        for (ObjectName candidate : candidates) {
            String keyValue = candidate.getKeyProperty(key);
            HashSet<ObjectName> typeSet = (HashSet<ObjectName>)setMap.get(keyValue);
            if (typeSet == null) {
                typeSet = new HashSet<ObjectName>();
                setMap.put(keyValue, typeSet);
            }
            typeSet.add(candidate);
        }
        return setMap;
    }

    protected final ObjectName registerNew(Object impl, ObjectName implObjectName, ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        if (impl == null) {
            String msg = "unable to create new impl for old: " + oldObjectName;
            this.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return this.mLoader.registerNew(impl, implObjectName, oldObjectName);
    }

    protected final void trace(Object o) {
        this.debug(o);
    }

    protected String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    protected Logger getLogger() {
        return this.mLoader.getMBeanLogger();
    }

    public String getAMXJMXDomainName() {
        return this.mLoader.getAMXJMXDomainName();
    }

    public MBeanServer getMBeanServer() {
        return this.mLoader.getMBeanServer();
    }

    private Constructor findConstructor(Constructor[] constructors, Class[] sig) {
        Constructor constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] csig = constructors[i].getParameterTypes();
            if (csig.length != sig.length) continue;
            constructor = constructors[i];
            for (int c = 0; c < sig.length; ++c) {
                if (csig[i].isAssignableFrom(sig[i])) continue;
                constructor = null;
                break;
            }
            if (constructor != null) break;
        }
        return constructor;
    }

    private Constructor getDelegateConstructor(Constructor[] constructors) {
        return this.findConstructor(constructors, DELEGATE_SIG);
    }

    private Constructor getEmptyConstructor(Constructor[] constructors) {
        return this.findConstructor(constructors, EMPTY_SIG);
    }

    protected Class getImplClass(ObjectName newObjectName, ObjectName oldObjectName) {
        String newType = Util.getJ2EEType(newObjectName);
        TypeInfo info = TypeInfos.getInstance().getInfo(newType);
        assert (info != null);
        Class implClass = info.getImplClass();
        return implClass;
    }

    protected Object newImpl(ObjectName newObjectName, ObjectName oldObjectName) throws Exception {
        Object impl;
        block6: {
            impl = null;
            Class implClass = this.getImplClass(newObjectName, oldObjectName);
            try {
                Constructor[] constructors = implClass.getConstructors();
                Constructor constructor = null;
                constructor = this.getDelegateConstructor(constructors);
                if (constructor != null) {
                    DelegateToMBeanDelegate delegate = new DelegateToMBeanDelegate(this.mLoader.getMBeanServer(), oldObjectName);
                    assert (delegate != null);
                    this.debug("created Delegate with target of " + oldObjectName + " for " + newObjectName);
                    impl = constructor.newInstance(delegate);
                    break block6;
                }
                if (this.getEmptyConstructor(constructors) != null) {
                    impl = implClass.newInstance();
                    break block6;
                }
                assert (false);
                throw new Error("Delegate has no constructor");
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtil.getRootCause(e);
                this.debug("Loader.newImpl: exception creating new impl: " + e + "\n" + ExceptionUtil.getStackTrace(rootCause));
                throw e;
            }
        }
        return impl;
    }

    protected ObjectName findExisting(Set<ObjectName> newObjectNames, ObjectName oldObjectName) {
        ObjectName resultName = null;
        if (newObjectNames.size() == 1) {
            resultName = GSetUtil.getSingleton(newObjectNames);
        }
        return resultName;
    }

    private final synchronized ObjectName ensureNew(ObjectName newObjectName, ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, Exception {
        ObjectName pattern = Util.newObjectNamePattern(newObjectName);
        Set<ObjectName> objectNames = JMXUtil.queryNames(this.getMBeanServer(), pattern, null);
        ObjectName existingObjectName = this.findExisting(objectNames, oldObjectName);
        ObjectName resultName = null;
        if (existingObjectName == null) {
            Object impl = this.newImpl(newObjectName, oldObjectName);
            resultName = this.registerNew(impl, newObjectName, oldObjectName);
        } else {
            resultName = existingObjectName;
        }
        assert (resultName != null);
        return resultName;
    }

    protected ObjectName syncWithOld(ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, Exception {
        ObjectName newObjectName = this.oldToNewObjectName(oldObjectName);
        this.debug("\nsyncWithOld: \n" + oldObjectName + "\n=>\n" + newObjectName);
        ObjectName resultName = this.ensureNew(newObjectName, oldObjectName);
        return resultName;
    }
}

